/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import gui.program.position.WaypointNode;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FixedRobot3DCanvas {
    private static final Dimension ROBOT_3D_IMAGE_SIZE = new Dimension(180, 180);
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private RobotCanvas3D robotCanvas3D;
    private ProgramVisualization programVisualizer;

    @Inject
    public FixedRobot3DCanvas(RobotCanvas3DFactory robotCanvas3DFactory) {
        this.robotCanvas3DFactory = robotCanvas3DFactory;
    }

    public Component buildComponent() {
        this.robotCanvas3D = this.robotCanvas3DFactory.buildPositionRobot();
        this.robotCanvas3D.setDebugName("G5 Waypoint Fixed Type 3D Canvas");
        this.programVisualizer = new ProgramVisualization(this.robotCanvas3D.isActualCanvas());
        if (this.robotCanvas3D.isActualCanvas()) {
            this.robotCanvas3D.addNodeToScene(this.programVisualizer.getElementNode());
        }
        this.programVisualizer.clearVisualization();
        this.robotCanvas3D.setVisible(false);
        this.robotCanvas3D.getComponent().setPreferredSize(ROBOT_3D_IMAGE_SIZE);
        this.robotCanvas3D.getComponent().setMaximumSize(ROBOT_3D_IMAGE_SIZE);
        return this.robotCanvas3D.getComponent();
    }

    public void enter(WaypointNode waypointNode) {
        this.robotCanvas3D.setVisible(!waypointNode.isInvalidWaypoint());
        if (this.robotCanvas3D.getComponent().isVisible()) {
            this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable(waypointNode.getActualJointPositionVector()));
        }
    }

    public void exit(boolean b) {
        this.robotCanvas3D.setVisible(b);
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private final JointPositionVector actualJointPositionVector;

        public UpdateGraphicsRunnable(JointPositionVector actualJointPositionVector) {
            this.actualJointPositionVector = actualJointPositionVector;
        }

        @Override
        public void run() {
            FixedRobot3DCanvas.this.robotCanvas3D.setRobotAttached(!this.actualJointPositionVector.isUndefined());
            FixedRobot3DCanvas.this.robotCanvas3D.setJointAngleVector(this.actualJointPositionVector);
            FixedRobot3DCanvas.this.programVisualizer.clearVisualization();
        }
    }
}

