/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.program.waypoint.infrastructure.LinkWaypointView$UnlinkingAction$AjcClosure1;
import com.ur.program.waypoint.infrastructure.NameableActiveNode;
import com.ur.program.waypoint.infrastructure.RenameWaypoint;
import com.ur.program.waypoint.infrastructure.WaypointNodeModel;
import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleAction;
import com.ur.reversible.UndoRedoListener;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.card.CardLayoutUtil;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramUndoRedoService;
import gui.program.SuppressedNode;
import gui.program.position.WaypointNode;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class LinkWaypointView
extends JPanel
implements Provider<WaypointNode> {
    private static final String LINKED = "linking combobox";
    private static final String UNLINKED = "unlinked label";
    public static final String RENAME_WAYPOINT = "GeomCardRenameWaypointButton";
    private final transient NamingService namingService;
    private ProgramLookupService programLookupService;
    private final JComboBox selectedWaypoint;
    private final JLabel waypointName;
    private final JPanel waypointNamePanel;
    private final JButton makeLink;
    private final JButton unlink;
    private WaypointNode currentNode;

    @Inject
    public LinkWaypointView(ViewContext viewContext, NamingService namingService, WaypointNodeValidationStrategyProvider validationStrategyProvider, ProgramLookupService programLookupService, ProgramUndoRedoService undoRedoService) {
        this.namingService = namingService;
        this.programLookupService = programLookupService;
        WidgetFactory factory = viewContext.createWidgetFactory();
        NameableActiveNode nameableActiveNode = new NameableActiveNode(this, namingService);
        RenameWaypoint renameListener = new RenameWaypoint(nameableActiveNode, validationStrategyProvider, viewContext);
        JButton renameWaypointButton = factory.createButton((Action)((Object)renameListener));
        this.waypointName = new JLabel();
        renameWaypointButton.setIcon(ProgramImageResource.rename());
        renameListener.bind(this.waypointName);
        renameListener.bind(renameWaypointButton);
        this.selectedWaypoint = factory.createComboBox();
        this.selectedWaypoint.addPopupMenuListener(new LinkPopupListener(viewContext));
        this.selectedWaypoint.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5), this.selectedWaypoint.getBorder()));
        renameWaypointButton.setName(RENAME_WAYPOINT);
        this.makeLink = factory.createButton((Action)((Object)new LinkingAction()));
        this.unlink = factory.createButton((Action)((Object)new UnlinkingAction(nameableActiveNode)));
        this.waypointNamePanel = new JPanel(new CardLayout());
        this.waypointNamePanel.add((Component)viewContext.createFormBuilder().component((JComponent)this.selectedWaypoint, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).component((JComponent)this.unlink, new FormBuilder.PanelConstraints[0]).getRow(), LINKED);
        this.waypointNamePanel.add((Component)viewContext.createFormBuilder().component((JComponent)this.waypointName, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).component((JComponent)this.makeLink, new FormBuilder.PanelConstraints[0]).getRow(), UNLINKED);
        JPanel panel = viewContext.createFormBuilder().component((JComponent)renameWaypointButton, new FormBuilder.PanelConstraints[0]).component((JComponent)this.waypointNamePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).getRow();
        this.setLayout(new BorderLayout());
        this.add(panel);
        undoRedoService.addListener((UndoRedoListener)new UndoRedoListener<AbstractProgramNode>(){

            public void perform(ReversibleAction reversibleAction, Reversible<AbstractProgramNode> reversible) {
                if ((reversibleAction == ReversibleAction.PostUndo || reversibleAction == ReversibleAction.PostRedo) && LinkWaypointView.this.currentNode != null) {
                    LinkWaypointView.this.update(LinkWaypointView.this.currentNode);
                }
            }
        });
    }

    public WaypointNode get() {
        return this.currentNode;
    }

    public void update(WaypointNode currentNode) {
        this.currentNode = currentNode;
        this.makeLink.setEnabled(this.moreThanOneWaypointAvailable());
        boolean showLinked = this.isThisWaypointLinked(currentNode);
        this.waypointName.setText(currentNode.getName());
        this.selectedWaypoint.setModel(WaypointNodeModel.includeSelf(currentNode, this.namingService));
        this.selectedWaypoint.setSelectedItem(currentNode.getName());
        CardLayoutUtil.flipToCard((JPanel)this.waypointNamePanel, (String)(showLinked ? LINKED : UNLINKED));
    }

    private boolean isThisWaypointLinked(WaypointNode currentNode) {
        return this.getWaypointNodesByTypeAndName(this.get().getPositionNodeType(), currentNode.getName()).size() > 1;
    }

    private boolean moreThanOneWaypointAvailable() {
        return this.getWaypointNodesOfType(this.get().getPositionNodeType()).size() > 1;
    }

    private List<WaypointNode> getWaypointNodesOfType(PositionNodeType type) {
        ArrayList<WaypointNode> result = new ArrayList<WaypointNode>();
        this.getWaypointNodesInSubtree(this.programLookupService.getProgramRootNode().children(), result, type);
        return result;
    }

    private void getWaypointNodesInSubtree(Enumeration<TreeNode> enumeration, Collection<WaypointNode> result, PositionNodeType type) {
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof AbstractProgramNode)) {
                return;
            }
            AbstractProgramNode node = (AbstractProgramNode)element;
            if (node instanceof WaypointNode && ((WaypointNode)node).getPositionNodeType() == type) {
                result.add((WaypointNode)node);
            }
            if (node instanceof SuppressedNode) continue;
            this.getWaypointNodesInSubtree(node.children(), result, type);
        }
    }

    private void updateLater(final WaypointNode waypointNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinkWaypointView.this.update(waypointNode);
            }
        });
    }

    private boolean isNodeLinkable(String nameOfNode) {
        boolean isLinkable = false;
        List<WaypointNode> waypointNodes = this.getWaypointNodesByTypeAndName(this.get().getPositionNodeType(), nameOfNode);
        for (WaypointNode waypointNode : waypointNodes) {
            isLinkable = waypointNode.isLinkable();
            if (!isLinkable) break;
        }
        return isLinkable;
    }

    private List<WaypointNode> getWaypointNodesByTypeAndName(PositionNodeType type, String name) {
        List<WaypointNode> waypointNodesOfType = this.getWaypointNodesOfType(type);
        ArrayList<WaypointNode> matchingTypeAndName = new ArrayList<WaypointNode>();
        for (WaypointNode each : waypointNodesOfType) {
            if (!name.equals(each.getName())) continue;
            matchingTypeAndName.add(each);
        }
        return matchingTypeAndName;
    }

    private class LinkPopupListener
    implements PopupMenuListener {
        private ViewContext viewContext;
        private boolean isCancelled = false;

        LinkPopupListener(ViewContext viewContext) {
            this.viewContext = viewContext;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.isCancelled = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            String nameOfSelectedNode = (String)LinkWaypointView.this.selectedWaypoint.getSelectedItem();
            if (this.isCancelled || this.isSameName(LinkWaypointView.this.currentNode, nameOfSelectedNode)) {
                LinkWaypointView.this.updateLater(LinkWaypointView.this.currentNode);
                return;
            }
            this.linkWaypoints(nameOfSelectedNode);
            this.showLinkStatusPopup(nameOfSelectedNode);
            LinkWaypointView.this.updateLater(LinkWaypointView.this.currentNode);
        }

        private boolean isSameName(WaypointNode waypointNode, String nameOfSelectedNode) {
            return waypointNode.getName().equals(nameOfSelectedNode);
        }

        private void showLinkStatusPopup(String nameOfSelectedNode) {
            if (LinkWaypointView.this.isThisWaypointLinked(LinkWaypointView.this.currentNode)) {
                DisplayMessageFactory.inform((JComponent)LinkWaypointView.this.unlink, (String)((TextResource)this.viewContext.getTextResource(TextResource.class)).waypointIsLinkedTo(LinkWaypointView.this.currentNode.getName()));
            } else if (!LinkWaypointView.this.currentNode.isLinkable() || !LinkWaypointView.this.isNodeLinkable(nameOfSelectedNode)) {
                DisplayMessageFactory.inform((JComponent)LinkWaypointView.this.makeLink, (String)((TextResource)this.viewContext.getTextResource(TextResource.class)).unableToLinkWaypoints());
            }
        }

        private void linkWaypoints(String selected) {
            LinkWaypointView.this.currentNode.setName(selected);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.isCancelled = true;
        }
    }

    private class LinkingAction
    extends AbstractActionDefinition {
        public LinkingAction() {
            this.putValue("SmallIcon", ProgramImageResource.linkIcon());
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
        }

        public void actionPerformed(ActionEvent e) {
            CardLayoutUtil.flipToCard((JPanel)LinkWaypointView.this.waypointNamePanel, (String)LinkWaypointView.LINKED);
            LinkWaypointView.this.selectedWaypoint.setModel(WaypointNodeModel.includeSelf(LinkWaypointView.this.currentNode, LinkWaypointView.this.namingService));
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LinkWaypointView.this.selectedWaypoint.showPopup();
                }
            });
        }
    }

    private class UnlinkingAction
    extends AbstractActionDefinition {
        private final NameableActiveNode nameableActiveNode;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public UnlinkingAction(NameableActiveNode nameableActiveNode) {
            this.nameableActiveNode = nameableActiveNode;
            this.putValue("SmallIcon", ProgramImageResource.linkIcon());
            this.putValue("Function", ActionDefinition.Function.PRIMARY_INLINE_ACTION);
        }

        @CompoundProgramChange
        public void actionPerformed(ActionEvent e) {
            ActionEvent actionEvent = e;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)actionEvent);
            Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
            LinkWaypointView$UnlinkingAction$AjcClosure1 linkWaypointView$UnlinkingAction$AjcClosure1 = new LinkWaypointView$UnlinkingAction$AjcClosure1(objectArray);
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(linkWaypointView$UnlinkingAction$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        static {
            UnlinkingAction.ajc$preClinit();
        }

        static final /* synthetic */ void actionPerformed_aroundBody0(UnlinkingAction ajc$this, ActionEvent e, JoinPoint joinPoint) {
            if (!ajc$this.LinkWaypointView.this.makeLink.isEnabled()) {
                return;
            }
            ajc$this.nameableActiveNode.unLink();
            ajc$this.LinkWaypointView.this.update(ajc$this.LinkWaypointView.this.currentNode);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("LinkWaypointView.java", UnlinkingAction.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "com.ur.program.waypoint.infrastructure.LinkWaypointView$UnlinkingAction", "java.awt.event.ActionEvent", "e", "", "void"), 204);
        }
    }
}

