/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.move.AutoMoveCallback;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.move.MoveRequestFactory;
import com.ur.polyscope.move.RobotMovement;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.program.internal.TextResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.view.hmc.HMC;
import gui.commandpanels.WaypointCard;
import gui.program.position.WaypointNode;
import java.awt.event.ActionEvent;

public class MoveRobotToWaypoint
extends AbstractActionDefinition {
    private final MoveRequestFactory moveRequestFactory;
    private WaypointNode waypointNode = null;
    private final RobotMovement robotMovement;
    private final HMC hmc;

    MoveRobotToWaypoint(TextResource textResource, MoveRequestFactory moveRequestFactory, RobotMovement robotMovement, HMC hmc) {
        this.putValue("Name", textResource.moveRobotHere());
        this.putValue("Function", ActionDefinition.Function.SECONDARY);
        this.putValue("InternalName", WaypointCard.MOVE_ROBOT_HERE);
        this.moveRequestFactory = moveRequestFactory;
        this.robotMovement = robotMovement;
        this.hmc = hmc;
    }

    public void setWaypointNode(WaypointNode waypointNode) {
        this.waypointNode = waypointNode;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.shouldPerformMoveL(RobotState.getLatestRobotState().jointPosition)) {
            Pose6d pose = this.waypointNode.getActualToolPose();
            MoveRequest moveRequest = this.moveRequestFactory.createMoveRequest(new ToolPosition(pose.toArray()), (AutoMoveCallback)new AutoMoveCallback.Template());
            this.robotMovement.moveTo(moveRequest);
        } else {
            MoveRequest moveRequest = this.moveRequestFactory.createMoveRequest(new JointConfiguration(this.waypointNode.getActualJointPositionVector().getJoints()), (AutoMoveCallback)new AutoMoveCallback.Template());
            this.robotMovement.moveTo(moveRequest);
        }
    }

    private boolean shouldPerformMoveL(JointPositionVector currentPosition) {
        if (this.waypointNode != null && this.waypointNode.isCartesianMotion()) {
            return this.hmc.canBeReachByMoveL(this.waypointNode.getPose6d(), currentPosition, this.waypointNode.getActualJointPositionVector());
        }
        return false;
    }
}

