/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.nodes.move.PositionType;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.program.internal.TextResource;
import com.ur.program.optimove.MotionControlsPanel;
import com.ur.program.optimove.OptiMoveParametersPanel;
import com.ur.program.optimove.SpeedAndAccelerationParametersPanel;
import com.ur.program.waypoint.infrastructure.OptiMoveEnablementLabelProvider;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.BindingRegistration;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.FormBuilder;
import com.ur.swing.IconAndLabelProvider;
import com.ur.swing.LabelProvider;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.TooltipFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogPriority;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import com.ur.swing.units.Units;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.action.DeleteNodeAction;
import com.ur.view.actions.AddNodeActionFactory;
import gui.commandpanels.MotionTypeLabelProvider;
import gui.commandpanels.MoveCard;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.DashBoard;
import gui.polyscope.setup.safety.FeatureIconAndLabelProvider;
import gui.program.CircleMoveNode;
import gui.program.MotionDefiningNode;
import gui.program.MoveNode;
import gui.program.OptiMoveNode;
import gui.program.UpdateExecutionFlowComponent;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReferenceBase;
import gui.program.validation.MoveNodeValidationStrategyProvider;
import gui.swing.renderers.FeatureComboBoxModel;
import gui.swing.renderers.TopLevelFeatureRenderingStrategy;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class OptimoveMoveCardImpl
extends MoveCard {
    public static final String SPEED = "speed.G5MoveCard";
    public static final String ACCELERATION = "acceleration.G5MoveCard";
    public static final String MOTION_TYPE = "motionType.G5MoveCard";
    public static final String BLEND_RADIUS = "blendRadius.G5MoveCard";
    public static final String ADD_CIRCLEMOVE_WAYPOINT_BUTTON = "ADD_CIRCLEMOVE_WAYPOINT.G5MoveCard";
    public static final String FEATURE_COMBOBOX = "feature.G5MoveCard";
    public static final String OPTIMOVE_COMBOBOX = "optiMoveEnablement.G5MoveCard";
    private boolean updating = false;
    private final AddNodeActionFactory entityFactory;
    private final ProgramReferenceService programReferenceService;
    private final RobotInstallationLookupService installationLookup;
    private final DeleteNodeAction deleteNodeAction;
    private final TooltipFactory tooltipFactory;
    private final ViewComponent tcpReferenceComponent;
    private final FeaturesLookup featuresLookup;
    private final ViewContext viewContext;
    private final DialogCreator dialogCreator;
    private JLabel addCircleMoveLabel;
    private final ValidationStrategy.ValidationWrapperStrategy speedValidationStrategy;
    private final ValidationStrategy.ValidationWrapperStrategy accelerationValidationStrategy;
    private final ValidationStrategy.ValidationWrapperStrategy blendValidationStrategy;
    private final MoveNodeValidationStrategyProvider validationStrategyProvider;
    private JLabel featureLabel;
    private ComboBox featureSelectComboBox;
    private ComboBox moveTypeComboBox;
    private JLabel processMoveBlendRadiusLabel;
    private NumberField processMoveBlendRadiusTextField;
    private JButton addCircleMove;
    private JCheckBox jointAngleCheckBox;
    private BindingRegistration toolTipBindingRegistration = BindingRegistration.NULL_REGISTRATION;
    private final ProgramFeatureService programFeatureService;
    private final MotionControlsPanel motionControlsPanel;
    private ComboBox optiMoveEnablementComboBox;

    @Inject
    OptimoveMoveCardImpl(ViewContext viewContext, AddNodeActionFactory entityFactory, ProgramReferenceService programReferenceService, RobotInstallationLookupService installationLookup, DeleteNodeAction deleteNodeAction, MoveNodeValidationStrategyProvider validationStrategyProvider, TooltipFactory tooltipFactory, @Named(value="g5-tcp-reference") @Named(value="g5-tcp-reference") ViewComponent tcpReferenceComponent, FeaturesLookup featuresLookup, ProgramFeatureService programFeatureService, DialogCreator dialogCreator, SpeedAndAccelerationParametersPanel speedAndAccelerationParametersPanel, OptiMoveParametersPanel optiMoveParametersPanel) {
        this.viewContext = viewContext;
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
        this.installationLookup = installationLookup;
        this.deleteNodeAction = deleteNodeAction;
        this.tooltipFactory = tooltipFactory;
        this.tcpReferenceComponent = tcpReferenceComponent;
        this.featuresLookup = featuresLookup;
        this.programFeatureService = programFeatureService;
        this.speedValidationStrategy = new ValidationStrategy.ValidationWrapperStrategy();
        this.accelerationValidationStrategy = new ValidationStrategy.ValidationWrapperStrategy();
        this.blendValidationStrategy = new ValidationStrategy.ValidationWrapperStrategy();
        this.validationStrategyProvider = validationStrategyProvider;
        this.dialogCreator = dialogCreator;
        this.motionControlsPanel = new MotionControlsPanel(viewContext, speedAndAccelerationParametersPanel, optiMoveParametersPanel);
        speedAndAccelerationParametersPanel.setNames(SPEED, ACCELERATION);
        this.initComponents();
        this.bindComponents();
    }

    private void bindComponents() {
        this.tcpReferenceComponent.setModifyListener(domainComponent -> ((MoveNode)this.getNode()).setTcp(domainComponent));
        TopLevelFeatureRenderingStrategy renderingStrategy = new TopLevelFeatureRenderingStrategy(this.featuresLookup);
        ComboBoxRenderer.bindRenderer((JComboBox)this.featureSelectComboBox, (RenderingStrategy)renderingStrategy);
        this.featureSelectComboBox.setRenderer((ListCellRenderer)new ContributedComboBoxRenderer((RenderingStrategy)renderingStrategy));
    }

    protected void updateCard() {
        this.updating = true;
        MoveNode node = (MoveNode)this.getNode();
        this.processMoveBlendRadiusLabel.setVisible(node.isProcessMove());
        this.processMoveBlendRadiusTextField.setVisible(node.isProcessMove());
        this.addCircleMove.setVisible(node.isProcessMove());
        this.addCircleMoveLabel.setVisible(node.isProcessMove());
        this.moveTypeComboBox.setSelectedItem((Object)node.getMotionType());
        if (node.isProcessMove()) {
            this.processMoveBlendRadiusTextField.setText(Units.convert_from_m((double)node.getSharedProcessMoveBlendRadius()));
        } else {
            this.processMoveBlendRadiusTextField.setText("0");
        }
        this.updateValidationStrategies();
        this.tcpReferenceComponent.setDomain(node.getTcp());
        this.featureSelectComboBox.setModel((ComboBoxModel)new FeatureComboBoxModel((InstallationComponentLookup)this.installationLookup, this.programReferenceService, node.getFeatureReference(), this.featuresLookup, false, this.programFeatureService));
        this.jointAngleCheckBox.setEnabled(node.isJointMove());
        this.jointAngleCheckBox.setSelected(node.getPositionType() == PositionType.JOINT_ANGLES);
        this.setTCPFeatureEnablement();
        this.motionControlsPanel.setOptiMoveNode((OptiMoveNode)node);
        this.motionControlsPanel.allowOptiMove(!node.isProcessMove());
        this.motionControlsPanel.updatePanel();
        this.optiMoveEnablementComboBox.setSelectedItem((Object)node.isUsingOptiMove());
        this.optiMoveEnablementComboBox.setEnabled(!node.isProcessMove());
        this.updating = false;
    }

    private void initComponents() {
        TextResource text = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        this.setLayout(new BorderLayout(0, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.featureLabel = factory.createLabel(text.Feature());
        this.featureSelectComboBox = factory.createComboBox((IconAndLabelProvider)new FeatureIconAndLabelProvider(), new Object[0]);
        this.featureSelectComboBox.setName(FEATURE_COMBOBOX);
        this.processMoveBlendRadiusLabel = factory.createLabel(text.blendWithRadius());
        this.processMoveBlendRadiusTextField = factory.createNumberField(e -> {
            MoveNode node = (MoveNode)this.getNode();
            if (node == null || this.processMoveBlendRadiusTextField.getText().isEmpty()) {
                return;
            }
            double blendDistance = Units.convert_to_m((String)this.processMoveBlendRadiusTextField.getText());
            node.setSharedProcessMoveBlendRadius(blendDistance);
            UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)node);
        });
        this.processMoveBlendRadiusTextField.setErrorValidationStrategy(new ValidationStrategy[]{this.blendValidationStrategy});
        this.processMoveBlendRadiusTextField.setConverter(Units.getMetersConverter());
        this.processMoveBlendRadiusTextField.setMode(Mode.PositiveNumbers);
        this.processMoveBlendRadiusTextField.setUnitWidth(60);
        this.processMoveBlendRadiusTextField.setName(BLEND_RADIUS);
        JButton resetFields = factory.createButton((Action)((Object)new ResetFieldsAction(text)));
        resetFields.setName(MoveCard.RESET);
        this.addCircleMove = factory.createButton(this.alterIconAndText(this.entityFactory.createAddCircleMoveNodeAction()));
        this.addCircleMove.setName(ADD_CIRCLEMOVE_WAYPOINT_BUTTON);
        this.moveTypeComboBox = factory.createComboBox((LabelProvider)new MotionTypeLabelProvider(LanguagePack.getCommandNamesResource()), (Object[])MotionDefiningNode.MotionType.values());
        this.moveTypeComboBox.setName(MOTION_TYPE);
        this.jointAngleCheckBox = factory.createCheckBox(text.jointAngles());
        this.jointAngleCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            ((MoveNode)this.getNode()).setPositionType(selected ? PositionType.JOINT_ANGLES : PositionType.CARTESIAN_POSE);
            this.setTCPFeatureEnablement();
        });
        JPanel tcpAndBlendPanel = this.viewContext.createFormBuilder().component(this.tcpReferenceComponent.asComponent(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(3).component((JComponent)this.processMoveBlendRadiusLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.processMoveBlendRadiusTextField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.jointAngleCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().getPanel();
        tcpAndBlendPanel.setBorder(new EmptyBorder(0, -5, 0, 0));
        this.optiMoveEnablementComboBox = factory.createComboBox((LabelProvider)new OptiMoveEnablementLabelProvider(this.viewContext), (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.optiMoveEnablementComboBox.setName(OPTIMOVE_COMBOBOX);
        this.optiMoveEnablementComboBox.addActionListener(e -> {
            if (this.optiMoveEnablementComboBox.getSelectedItem() == null) {
                return;
            }
            ((MoveNode)this.getNode()).setUsingOptiMove(((Boolean)this.optiMoveEnablementComboBox.getSelectedItem()).booleanValue());
            ((MoveNode)this.getNode()).textHasChanged();
        });
        this.add(this.viewContext.createFormBuilder().headerLabel(text.Move(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).spacer().component((JComponent)this.moveTypeComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().description(text.commandMove(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().headerLabel(((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).Position(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().headerLabel(text.Motion(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.featureLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().label(text.motionControls(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.featureSelectComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().component((JComponent)this.optiMoveEnablementComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)tcpAndBlendPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_12_ROWS}).spacer().component((JComponent)this.motionControlsPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_12_ROWS}).end(12).groupColumns(new int[]{5}).getPanel());
        JPanel addCircleMovePanel = this.createButtonActionPanel();
        this.add(this.viewContext.createFormBuilder().component((JComponent)addCircleMovePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer(3).component((JComponent)resetFields, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).getPanel(), "South");
        this.featureSelectComboBox.addActionListener(evt -> {
            if (this.updating) {
                return;
            }
            Object selectedItem = this.featureSelectComboBox.getSelectedItem();
            if (selectedItem instanceof GeomFeatureReferenceBase) {
                ((MoveNode)this.getNode()).setFeatureReference((GeomFeatureReferenceBase)selectedItem);
            }
        });
        addCircleMovePanel.add(this.addCircleMove);
        addCircleMovePanel.add(new JLabel("   "));
        this.addCircleMoveLabel = new JLabel(text.addCircleMove());
        addCircleMovePanel.add(this.addCircleMoveLabel);
        this.moveTypeComboBox.addActionListener(evt -> {
            MoveNode node = (MoveNode)this.getNode();
            if (this.updating || node == null) {
                return;
            }
            this.toolTipBindingRegistration.removeRegistration();
            Object value = this.moveTypeComboBox.getSelectedItem();
            if (value instanceof MotionDefiningNode.MotionType) {
                if (!node.canSetMotionType((MotionDefiningNode.MotionType)value)) {
                    DialogMessage dialogMessage = new DialogMessage(((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).Message(), text.CannotConvertToMoveJ());
                    dialogMessage.setPriority(DialogPriority.LOW);
                    this.dialogCreator.showMessageDialog(dialogMessage, MessageDialogType.MESSAGE, null);
                    this.moveTypeComboBox.setSelectedItem((Object)node.getMotionType());
                } else {
                    this.setMotionType(value, text);
                }
            }
        });
    }

    private void setMotionType(Object value, TextResource text) {
        if (value != MotionDefiningNode.MotionType.PROCESS_MOVE && this.isAnyImmediateDescendantCircleMove((MoveNode)this.getNode())) {
            String explanation = text.deleteCircleMove(LanguagePack.getCommandNamesResource().MoveP());
            if (LegacyURDialogCreator.confirmMessageDialog((ConfirmationMessage)new ConfirmationMessage(text.deleteCircleMoveHeader(), explanation, text.deleteCircleMoveButton(), ((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).Cancel())) == DialogReturnValue.OK) {
                this.deleteCircleMoveDescendants((MoveNode)this.getNode());
                ((MoveNode)this.getNode()).setMotionType((MotionDefiningNode.MotionType)value);
            } else {
                this.moveTypeComboBox.setSelectedItem((Object)MotionDefiningNode.MotionType.PROCESS_MOVE);
            }
        } else if (value != MotionDefiningNode.MotionType.JOINT_MOVE && ((MoveNode)this.getNode()).getPositionType() == PositionType.JOINT_ANGLES) {
            this.toolTipBindingRegistration = this.tooltipFactory.showInformationTooltipCloseAnyClick((JComponent)this.jointAngleCheckBox, text.jointAnglesNotSupported());
        } else {
            ((MoveNode)this.getNode()).setMotionType((MotionDefiningNode.MotionType)value);
        }
    }

    private void setTCPFeatureEnablement() {
        boolean isPose = ((MoveNode)this.getNode()).getPositionType() == PositionType.CARTESIAN_POSE;
        this.tcpReferenceComponent.asComponent().setEnabled(isPose);
        this.featureLabel.setEnabled(isPose);
        this.featureSelectComboBox.setEnabled(isPose);
    }

    private void deleteCircleMoveDescendants(MoveNode node) {
        Enumeration children = node.children();
        ArrayList<AbstractProgramNode> nodesToDelete = new ArrayList<AbstractProgramNode>();
        while (children.hasMoreElements()) {
            AbstractProgramNode o = (AbstractProgramNode)children.nextElement();
            if (!(o instanceof CircleMoveNode)) continue;
            nodesToDelete.add(o);
        }
        for (AbstractProgramNode programNode : nodesToDelete) {
            this.deleteNodeAction.execute(programNode);
        }
        ((ProgramSelectionModel)DashBoard.getProgram().getComponent(ProgramSelectionModel.class)).setSelected((AbstractProgramNode)node);
    }

    private boolean isAnyImmediateDescendantCircleMove(MoveNode node) {
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            Object o = children.nextElement();
            if (!(o instanceof CircleMoveNode)) continue;
            return true;
        }
        return false;
    }

    private Action alterIconAndText(Action action) {
        action.putValue("Name", "");
        action.putValue("SmallIcon", ViewImageResource.gtkAdd());
        action.putValue("Function", ActionDefinition.Function.SECONDARY);
        return action;
    }

    private JPanel createButtonActionPanel() {
        JPanel result = new JPanel(new FlowLayout(0, 0, 0));
        result.setBorder(BorderFactory.createEmptyBorder());
        return result;
    }

    private void updateValidationStrategies() {
        MoveNode node = (MoveNode)this.getNode();
        if (node.isCartesianMotion()) {
            this.speedValidationStrategy.setStrategy((ValidationStrategy)this.validationStrategyProvider.getCartesianJointSpeedLimitValidator());
            this.accelerationValidationStrategy.setStrategy((ValidationStrategy)this.validationStrategyProvider.getCartesianJointAccelerationLimitValidator());
        } else {
            this.speedValidationStrategy.setStrategy((ValidationStrategy)this.validationStrategyProvider.getJointSpeedLimitValidator());
            this.accelerationValidationStrategy.setStrategy((ValidationStrategy)this.validationStrategyProvider.getJointAccelerationLimitValidator());
        }
        if (node.isProcessMove()) {
            this.blendValidationStrategy.setStrategy((ValidationStrategy)this.validationStrategyProvider.getBlendRadiusValidator());
        } else {
            this.blendValidationStrategy.setStrategy((ValidationStrategy)AutoCorrectionValidator.ALWAYS_VALID);
        }
    }

    private class ResetFieldsAction
    extends AbstractActionDefinition {
        public ResetFieldsAction(TextResource text) {
            this.putValue("Name", text.resetSettings());
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
        }

        public void actionPerformed(ActionEvent e) {
            ((MoveNode)OptimoveMoveCardImpl.this.getNode()).resetToDefaults();
            OptimoveMoveCardImpl.this.updateCard();
        }
    }
}

