/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.program.internal.TextResource;
import com.ur.program.waypoint.infrastructure.WaypointFixedTypePanel;
import com.ur.resources.IllustrationImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.G5LookAndFeel;
import gui.commandpanels.PositionCard;
import gui.program.PatternNode;
import gui.program.position.PositionNode;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class PositionCardImpl
extends PositionCard {
    private final ViewContext viewContext;
    private JLabel illustrationLabel;
    private FlippablePanel waypointTypePanel;

    @Inject
    PositionCardImpl(ViewContext viewContext, WaypointFixedTypePanel fixedTypePanel) {
        this.viewContext = viewContext;
        WidgetFactory factory = viewContext.createWidgetFactory();
        this.setName("PositionCard");
        this.waypointTypePanel = new FlippablePanel();
        this.waypointTypePanel.addCardPanel((CardPanel)fixedTypePanel);
        this.waypointTypePanel.setCardParent((CardPanel)this);
        this.illustrationLabel = new JLabel("The good stuff");
        this.illustrationLabel.setIconTextGap(15);
        this.illustrationLabel.setFont(viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MEDIUM));
        this.illustrationLabel.setHorizontalAlignment(0);
        this.illustrationLabel.setVerticalAlignment(1);
        this.illustrationLabel.setVerticalTextPosition(1);
        this.illustrationLabel.setHorizontalTextPosition(0);
        viewContext.createFormBuilder().headerLabel(((CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class)).Position(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().component((JComponent)this.waypointTypePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).end(10).end(2).component(factory.createSeparator(G5LookAndFeel.BETWEEN_CARD_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.illustrationLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).end(10).setOnPanel((JPanel)((Object)this));
    }

    public void enter(Object o) {
        this.waypointTypePanel.switchTo(WaypointFixedTypePanel.class, o);
        super.enter(o);
    }

    public Object exit() {
        this.waypointTypePanel.exitActiveChild();
        return super.exit();
    }

    protected void updateCard() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        PositionNode node = (PositionNode)this.getNode();
        this.waypointTypePanel.exitActiveChild();
        this.waypointTypePanel.enterActiveChild((Object)node);
        AbstractProgramNode parent = (AbstractProgramNode)node.getParent();
        this.illustrationLabel.setText("");
        this.illustrationLabel.setIcon(null);
        if (parent instanceof PatternNode) {
            int childIndex = parent.getIndex((TreeNode)node);
            PatternNode.Type dim = ((PatternNode)parent).getDimensionality();
            block0 : switch (dim) {
                case LIST: {
                    this.illustrationLabel.setText(textResource.listMoveToThePosition());
                    break;
                }
                case LINE: {
                    switch (childIndex) {
                        case 0: {
                            this.illustrationLabel.setText(textResource.lineMoveToPositionX(1));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid1pos1d());
                            break;
                        }
                        case 1: {
                            this.illustrationLabel.setText(textResource.lineMoveToPositionX(2));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid2pos1d());
                        }
                    }
                    break;
                }
                case SQUARE_OBSOLETE: 
                case SQUARE: {
                    switch (childIndex) {
                        case 0: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(1));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid1pos2d());
                            break;
                        }
                        case 1: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(2));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid2pos2d());
                            break;
                        }
                        case 2: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(3));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid3pos2d());
                            break;
                        }
                        case 3: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(4));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid4pos2d());
                        }
                    }
                    break;
                }
                case BOX_OBSOLETE: 
                case BOX: {
                    switch (childIndex) {
                        case 0: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(1));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid1pos3d());
                            break block0;
                        }
                        case 1: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(2));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid2pos3d());
                            break block0;
                        }
                        case 2: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(3));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid3pos3d());
                            break block0;
                        }
                        case 3: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(4));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid4pos3d());
                            break block0;
                        }
                        case 4: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(5));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid5pos3d());
                            break block0;
                        }
                        case 5: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(6));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid6pos3d());
                            break block0;
                        }
                        case 6: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(7));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid7pos3d());
                            break block0;
                        }
                        case 7: {
                            this.illustrationLabel.setText(textResource.squareAndBoxMoveToPositionX(8));
                            this.illustrationLabel.setIcon(IllustrationImageResource.grid8pos3d());
                        }
                    }
                }
            }
        }
    }
}

