/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.program.internal.TextResource;
import com.ur.program.waypoint.infrastructure.NameableActiveNode;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ViewContext;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;

class RenameWaypoint
extends AbstractActionDefinition {
    final ValidationStrategy validator;
    private final NameableActiveNode waypointCard;
    private final ViewContext viewContext;

    RenameWaypoint(NameableActiveNode waypointCard, WaypointNodeValidationStrategyProvider validationStrategyProvider, ViewContext viewContext) {
        this.waypointCard = waypointCard;
        this.viewContext = viewContext;
        this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
        this.validator = validationStrategyProvider.getWaypointNameValidator();
    }

    public void bind(JComponent component) {
        TextHolder provider = new TextHolder(){

            public String getText() {
                return RenameWaypoint.this.waypointCard.getName();
            }

            public void setText(String text) {
                RenameWaypoint.this.waypointCard.setName(text);
            }
        };
        TextFieldUtils.bindTextPicker((JComponent)component, (TextHolder)provider, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{this.validator, new UnusedWaypointName(this.waypointCard)}));
    }

    public void actionPerformed(ActionEvent e) {
    }

    private class UnusedWaypointName
    implements ValidationStrategy {
        String variableExistsMsg;
        private final NameableActiveNode activeNode;

        public UnusedWaypointName(NameableActiveNode activeNode) {
            this.variableExistsMsg = ((TextResource)RenameWaypoint.this.viewContext.getTextResource(TextResource.class)).variableNameAlreadyExists();
            this.activeNode = activeNode;
        }

        public boolean isValid(String uncheckedString) {
            if (this.activeNode.getName().equals(uncheckedString)) {
                return true;
            }
            return !this.activeNode.isNameUsed(uncheckedString);
        }

        public String getErrorMessage(String uncheckedString) {
            return this.variableExistsMsg;
        }
    }
}

