/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.move.MoveTab;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.move.MoveRequestFactory;
import com.ur.polyscope.move.RobotMovement;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.program.waypoint.infrastructure.EditWaypointFactory;
import com.ur.program.waypoint.infrastructure.FixedRobot3DCanvas;
import com.ur.program.waypoint.infrastructure.LinkWaypointView;
import com.ur.program.waypoint.infrastructure.MoveRobotToWaypoint;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.card.CardLayoutUtil;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.view.hmc.HMC;
import gui.commandpanels.WaypointCard;
import gui.program.position.ImagePlaceHolder;
import gui.program.position.WaypointNode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.java.balloontip.BalloonTip;

public class WaypointFixedTypePanel
extends CardPanel {
    private static final Dimension ROBOT_3D_IMAGE_SIZE = new Dimension(180, 180);
    private static final String SHOW_POSE = "DEFINED";
    private static final String UNDEFINED_POSE = "UNDEFINED";
    private static final String UNREACHABLE_POSE = "UNREACHABLE";
    private final MoveRequestFactory moveRequestFactory;
    private final RobotMovement robotMovement;
    private final FixedRobot3DCanvas fixedRobotCanvas;
    private final EditWaypointFactory editPoseButtonFactory;
    private WaypointNode waypointNode;
    private JButton moveRobotHereButton;
    private final WidgetFactory widgetFactory;
    private final PoweredOnRobotRequirement poweredOnRobotRequirement;
    private final LinkWaypointView linkWaypointView;
    private final ViewContext viewContext;
    private JPanel imagePlaceholder;
    private JButton editPoseButton;
    private JLabel unreachableWaypointHelper;
    private MoveRobotToWaypoint moveRobotToWaypoint;

    @Inject
    public WaypointFixedTypePanel(ViewContext viewContext, PoweredOnRobotRequirement poweredOnRobotRequirement, EditWaypointFactory editPoseButtonFactory, LinkWaypointView linkWaypointView, FixedRobot3DCanvas fixedRobotCanvas, MoveRequestFactory moveRequestFactory, RobotMovement robotMovement) {
        this.viewContext = viewContext;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.poweredOnRobotRequirement = poweredOnRobotRequirement;
        this.linkWaypointView = linkWaypointView;
        this.moveRequestFactory = moveRequestFactory;
        this.robotMovement = robotMovement;
        this.fixedRobotCanvas = fixedRobotCanvas;
        this.editPoseButtonFactory = editPoseButtonFactory;
        this.initComponents();
    }

    public void enter(Object o) {
        super.enter(o);
        WaypointNode newWaypointNode = (WaypointNode)o;
        this.linkWaypointView.update(newWaypointNode);
        if (this.waypointNode == o) {
            return;
        }
        this.waypointNode = newWaypointNode;
        this.setupComponents(newWaypointNode);
        this.fixedRobotCanvas.enter(newWaypointNode);
    }

    private void setupComponents(WaypointNode waypointNode) {
        boolean waypointIsDefined = !waypointNode.isInvalidWaypoint();
        boolean waypointIsReachable = !waypointNode.getActualJointPositionVector().isUndefined();
        String robotImageSelector = SHOW_POSE;
        if (!waypointIsDefined) {
            robotImageSelector = UNDEFINED_POSE;
        } else if (!waypointIsReachable) {
            robotImageSelector = UNREACHABLE_POSE;
        }
        CardLayoutUtil.flipToCard((JPanel)this.imagePlaceholder, (String)robotImageSelector);
        this.moveRobotToWaypoint.setWaypointNode(waypointNode);
        this.moveRobotHereButton.setEnabled(waypointIsDefined && waypointIsReachable);
        this.editPoseButton.setEnabled(waypointIsReachable || !waypointIsDefined);
        this.unreachableWaypointHelper.setVisible(waypointIsDefined && !waypointIsReachable);
        this.imagePlaceholder.setBorder(BorderFactory.createLineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR, 3));
    }

    public Object exit() {
        CardLayoutUtil.flipToCard((JPanel)this.imagePlaceholder, (String)UNDEFINED_POSE);
        this.fixedRobotCanvas.exit(false);
        this.waypointNode = null;
        return super.exit();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        JButton setWaypoint = this.widgetFactory.createButton((Action)((Object)new SetPositionAction(resource)));
        setWaypoint.putClientProperty("ignore-read-only", true);
        this.editPoseButton = this.editPoseButtonFactory.create(this::handlePoseEdit, (Provider<WaypointNode>)((Provider)() -> this.waypointNode), this);
        JPanel buttonsPanel = this.viewContext.createFormBuilder().component((JComponent)this.linkWaypointView, new FormBuilder.PanelConstraints[0]).end().end().component((JComponent)setWaypoint, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW}).end().end().component((JComponent)this.editPoseButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW}).end().getPanel();
        Icon unreachableInfoIcon = ProgramImageResource.questionMark();
        int spacerWidth = 2;
        int rightSpacerWidth = unreachableInfoIcon.getIconWidth() + spacerWidth;
        Dimension moveButtonSize = new Dimension(WaypointFixedTypePanel.ROBOT_3D_IMAGE_SIZE.width, 40);
        this.moveRobotToWaypoint = new MoveRobotToWaypoint(resource, this.moveRequestFactory, this.robotMovement, new HMC());
        this.moveRobotHereButton = this.widgetFactory.createButton((Action)((Object)this.moveRobotToWaypoint));
        this.moveRobotHereButton.putClientProperty("ignore-read-only", true);
        this.moveRobotHereButton.setMaximumSize(moveButtonSize);
        this.moveRobotHereButton.setMinimumSize(moveButtonSize);
        this.moveRobotHereButton.setPreferredSize(moveButtonSize);
        int moveButtonPanelWidth = WaypointFixedTypePanel.ROBOT_3D_IMAGE_SIZE.width + rightSpacerWidth;
        JPanel moveButtonPanel = new JPanel();
        moveButtonPanel.setLayout(new BorderLayout());
        moveButtonPanel.add((Component)this.moveRobotHereButton, "West");
        moveButtonPanel.setMaximumSize(new Dimension(moveButtonPanelWidth, 40));
        moveButtonPanel.setMinimumSize(new Dimension(moveButtonPanelWidth, 40));
        moveButtonPanel.setPreferredSize(new Dimension(moveButtonPanelWidth, 40));
        JPanel moveButtonSpacer = new JPanel();
        moveButtonSpacer.setSize(rightSpacerWidth, 40);
        moveButtonPanel.add((Component)moveButtonSpacer, "East");
        this.fixedRobotCanvas.buildComponent();
        this.imagePlaceholder = new JPanel(new CardLayout());
        this.imagePlaceholder.setBorder(BorderFactory.createLineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR, 3));
        this.imagePlaceholder.setPreferredSize(ROBOT_3D_IMAGE_SIZE);
        this.imagePlaceholder.setMaximumSize(ROBOT_3D_IMAGE_SIZE);
        this.imagePlaceholder.add((Component)new ImagePlaceHolder(true, false, this.viewContext, ROBOT_3D_IMAGE_SIZE), UNDEFINED_POSE);
        this.imagePlaceholder.add((Component)new ImagePlaceHolder(false, true, this.viewContext, ROBOT_3D_IMAGE_SIZE), UNREACHABLE_POSE);
        this.imagePlaceholder.add(this.fixedRobotCanvas.buildComponent(), SHOW_POSE);
        Dimension unreachableWaypointHelperSize = new Dimension(rightSpacerWidth, unreachableInfoIcon.getIconHeight());
        this.unreachableWaypointHelper = new JLabel();
        this.unreachableWaypointHelper.setIcon(unreachableInfoIcon);
        this.unreachableWaypointHelper.setMaximumSize(unreachableWaypointHelperSize);
        this.unreachableWaypointHelper.setMinimumSize(unreachableWaypointHelperSize);
        this.unreachableWaypointHelper.setPreferredSize(unreachableWaypointHelperSize);
        this.unreachableWaypointHelper.addMouseListener(this.createMouseListener());
        JPanel unreachablePanel = new JPanel();
        unreachablePanel.setLayout(new BorderLayout());
        unreachablePanel.setBorder(new EmptyBorder(0, spacerWidth, 0, 0));
        unreachablePanel.setPreferredSize(unreachableWaypointHelperSize);
        unreachablePanel.setMaximumSize(unreachableWaypointHelperSize);
        unreachablePanel.setMinimumSize(unreachableWaypointHelperSize);
        unreachablePanel.add((Component)this.unreachableWaypointHelper, "South");
        JPanel posePanel = new JPanel();
        posePanel.setLayout(new BorderLayout());
        posePanel.add((Component)this.imagePlaceholder, "Center");
        posePanel.add((Component)unreachablePanel, "East");
        JPanel rightSide = new JPanel(new BorderLayout(10, 10));
        rightSide.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        rightSide.setMaximumSize(new Dimension(moveButtonPanelWidth, 250));
        rightSide.setMinimumSize(new Dimension(moveButtonPanelWidth, 250));
        rightSide.setPreferredSize(new Dimension(moveButtonPanelWidth, 250));
        rightSide.add((Component)posePanel, "Center");
        rightSide.add((Component)moveButtonPanel, "South");
        this.add(Box.createHorizontalStrut(75));
        this.add(buttonsPanel);
        this.add(Box.createHorizontalStrut(30));
        this.add(rightSide);
        this.add(Box.createHorizontalStrut(75 - rightSpacerWidth));
    }

    private void handlePoseEdit() {
        this.fixedRobotCanvas.exit(false);
    }

    private MouseAdapter createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DisplayMessageFactory.informCloseAnyClick((JComponent)WaypointFixedTypePanel.this.unreachableWaypointHelper, (String)((TextResource)WaypointFixedTypePanel.this.viewContext.getTextResource(TextResource.class)).unreachableWaypointReset(), (BalloonTip.AttachLocation)BalloonTip.AttachLocation.NORTHWEST, (Dimension)new Dimension(100, 100), null);
            }
        };
    }

    private class SetPositionAction
    extends AbstractActionDefinition {
        SetPositionAction(TextResource textResource) {
            this.putValue("Name", textResource.setThisWaypoint());
            this.putValue("Function", ActionDefinition.Function.PRIMARY);
            this.putValue("InternalName", WaypointCard.SET_WAYPOINT);
        }

        public void actionPerformed(ActionEvent e) {
            if (WaypointFixedTypePanel.this.poweredOnRobotRequirement.checkAndNotify()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WaypointFixedTypePanel.this.stackCurrentCardAndSwitchTo(MoveTab.class, WaypointFixedTypePanel.this.waypointNode);
                    }
                });
            }
        }
    }
}

