/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.MoveTab;
import com.ur.move.automove.AutoMoveTab;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.program.internal.TextResource;
import com.ur.program.waypoint.infrastructure.LinkWaypointView;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogPriority;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.units.Units;
import com.ur.util.swing.HTML;
import gui.polyscope.DashBoard;
import gui.program.position.MeasuredWaypointNode;
import gui.program.position.WaypointNode;
import gui.tools.DialogCreator;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaypointRelativeTypePanel
extends CardPanel {
    private final LinkWaypointView linkWaypointView;
    private final ViewContext viewContext;
    private final DialogCreator dialogCreator;
    private DecimalFormat decimalFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###0.0");
    private MeasuredWaypointNode waypointNode = null;
    private JLabel distanceLabel;
    private JLabel angleLabel;
    private JButton moveToFromPosButton;
    private JButton moveToToPosButton;

    @Inject
    public WaypointRelativeTypePanel(ViewContext viewContext, LinkWaypointView linkWaypointView, PoweredOnRobotRequirement poweredOnRobotRequirement, DialogCreator dialogCreator) {
        this.linkWaypointView = linkWaypointView;
        this.viewContext = viewContext;
        this.dialogCreator = dialogCreator;
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.distanceLabel = new JLabel(HTML.html((String)HTML.h1((String)"100 mm")));
        this.angleLabel = new JLabel(HTML.html((String)HTML.h1((String)"60 deg")));
        JPanel distancePanel = widgetFactory.createTitleValuePair(textResource.distance(), this.distanceLabel);
        JPanel anglePanel = widgetFactory.createTitleValuePair(textResource.angle(), this.angleLabel);
        distancePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        anglePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JLabel description = new JLabel(textResource.relativeMotionGivenByTheDifferenceBetweenFromAndToPositions());
        description.setFont(viewContext.getFontFactory().getRelativeFont(URFontFactory.Size.SMALL));
        JButton setFromPosButton = widgetFactory.createButton((Action)((Object)new SetFromPositionAction(textResource, poweredOnRobotRequirement)));
        JButton setToPosButton = widgetFactory.createButton((Action)((Object)new SetToPositionAction(textResource, poweredOnRobotRequirement)));
        this.moveToFromPosButton = widgetFactory.createButton((Action)((Object)new MoveTo_FromPositionAction(textResource, poweredOnRobotRequirement)));
        this.moveToToPosButton = widgetFactory.createButton((Action)((Object)new MoveTo_ToPositionAction(textResource, poweredOnRobotRequirement)));
        viewContext.createFormBuilder().spacer().component((JComponent)linkWaypointView, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer(2).end().end().component((JComponent)description, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).component((JComponent)distancePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().label(textResource.fromPointDot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).spacer().label(textResource.toPointDot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)setFromPosButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).spacer().component((JComponent)setToPosButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().spacer(5).component((JComponent)anglePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().component((JComponent)this.moveToFromPosButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).spacer().component((JComponent)this.moveToToPosButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().groupColumns(new int[]{1, 3, 5}).setOnPanel((JPanel)((Object)this));
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_waypoint_relative");
    }

    public void enter(Object o) {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.waypointNode = (MeasuredWaypointNode)o;
        this.linkWaypointView.update((WaypointNode)this.waypointNode);
        if (this.waypointNode.getRelativeFromJointPositionVector() == null || this.waypointNode.getRelativeFromJointPositionVector().isUndefined()) {
            this.moveToFromPosButton.setEnabled(false);
        } else {
            this.moveToFromPosButton.setEnabled(true);
        }
        if (this.waypointNode.getJointPositionVector() == null || this.waypointNode.getJointPositionVector().isUndefined()) {
            this.moveToToPosButton.setEnabled(false);
        } else {
            this.moveToToPosButton.setEnabled(true);
        }
        double distance = this.waypointNode.getDistanceBetweenPoints();
        if (distance == Double.NaN) {
            this.distanceLabel.setText(textResource.distanceIsUndefined());
            this.angleLabel.setText(textResource.angleIsUndefined());
        } else {
            String measuredAngleBetweenPoints = this.decimalFormat.format(this.waypointNode.getAngleBetweenPoints() * 180.0 / Math.PI);
            this.distanceLabel.setText(HTML.html((String)HTML.h1((String)(String.valueOf(Units.convert_from_m((double)distance)) + " " + Units.getText().unitMm()))));
            this.angleLabel.setText(HTML.html((String)HTML.h1((String)(String.valueOf(measuredAngleBetweenPoints) + " " + Units.getText().unitDegrees()))));
        }
    }

    private class MoveTo_FromPositionAction
    extends AbstractActionDefinition {
        private final PoweredOnRobotRequirement robotRequirement;

        MoveTo_FromPositionAction(TextResource text, PoweredOnRobotRequirement robotRequirement) {
            this.robotRequirement = robotRequirement;
            this.putValue("Name", text.moveRobotHere());
        }

        public void actionPerformed(ActionEvent e) {
            DashBoard.stopProgram();
            if (this.robotRequirement.checkAndNotify()) {
                JointPositionVector currentPosition = RobotState.getLatestRobotState().jointPosition;
                if (!currentPosition.epsilonEquals(WaypointRelativeTypePanel.this.waypointNode.getActualFromJointPositionVector(), 0.005)) {
                    WaypointRelativeTypePanel.this.stackCurrentCardAndSwitchTo(AutoMoveTab.class, WaypointRelativeTypePanel.this.waypointNode.getActualFromJointPositionVector());
                } else {
                    DialogMessage dialogMessage = new DialogMessage(((com.ur.i18n.TextResource)WaypointRelativeTypePanel.this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).Message(), ((TextResource)WaypointRelativeTypePanel.this.viewContext.getTextResource(TextResource.class)).robotIsAlreadAtThisPosition());
                    dialogMessage.setPriority(DialogPriority.LOW);
                    WaypointRelativeTypePanel.this.dialogCreator.showMessageDialog(dialogMessage, MessageDialogType.MESSAGE, null);
                }
            }
        }
    }

    private class MoveTo_ToPositionAction
    extends AbstractActionDefinition {
        private final PoweredOnRobotRequirement robotRequirement;

        MoveTo_ToPositionAction(TextResource text, PoweredOnRobotRequirement robotRequirement) {
            this.robotRequirement = robotRequirement;
            this.putValue("Name", text.moveRobotHere());
        }

        public void actionPerformed(ActionEvent e) {
            DashBoard.stopProgram();
            if (this.robotRequirement.checkAndNotify()) {
                JointPositionVector currentPosition = RobotState.getLatestRobotState().jointPosition;
                if (!currentPosition.epsilonEquals(WaypointRelativeTypePanel.this.waypointNode.getActualJointPositionVector(), 0.005)) {
                    WaypointRelativeTypePanel.this.stackCurrentCardAndSwitchTo(AutoMoveTab.class, WaypointRelativeTypePanel.this.waypointNode.getActualJointPositionVector());
                } else {
                    DialogMessage dialogMessage = new DialogMessage(((com.ur.i18n.TextResource)WaypointRelativeTypePanel.this.viewContext.getTextResource(com.ur.i18n.TextResource.class)).Message(), ((TextResource)WaypointRelativeTypePanel.this.viewContext.getTextResource(TextResource.class)).robotIsAlreadAtThisPosition());
                    dialogMessage.setPriority(DialogPriority.LOW);
                    WaypointRelativeTypePanel.this.dialogCreator.showMessageDialog(dialogMessage, MessageDialogType.MESSAGE, null);
                }
            }
        }
    }

    private class SetFromPositionAction
    extends AbstractActionDefinition {
        private final PoweredOnRobotRequirement robotRequirement;

        SetFromPositionAction(TextResource text, PoweredOnRobotRequirement robotRequirement) {
            this.robotRequirement = robotRequirement;
            this.putValue("Name", text.setThisPoint());
        }

        public void actionPerformed(ActionEvent e) {
            if (this.robotRequirement.checkAndNotify()) {
                WaypointRelativeTypePanel.this.waypointNode.setGettingFromPosition(true);
                WaypointRelativeTypePanel.this.stackCurrentCardAndSwitchTo(MoveTab.class, WaypointRelativeTypePanel.this.waypointNode);
            }
        }
    }

    private class SetToPositionAction
    extends AbstractActionDefinition {
        private final PoweredOnRobotRequirement robotRequirement;

        SetToPositionAction(TextResource text, PoweredOnRobotRequirement robotRequirement) {
            this.robotRequirement = robotRequirement;
            this.putValue("Name", text.setThisPoint());
        }

        public void actionPerformed(ActionEvent e) {
            if (this.robotRequirement.checkAndNotify()) {
                WaypointRelativeTypePanel.this.waypointNode.setGettingFromPosition(false);
                WaypointRelativeTypePanel.this.stackCurrentCardAndSwitchTo(MoveTab.class, WaypointRelativeTypePanel.this.waypointNode);
            }
        }
    }
}

