/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.program.internal.TextResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.core.VariableSet;
import com.ur.view.variables.domain.VariableLookupService;
import gui.program.position.WaypointNode;
import gui.program.services.GeomFeatureVariable;
import gui.swing.renderers.VariableComboBoxModel;
import gui.swing.renderers.VariableRenderingStrategy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaypointVariableTypePanel
extends CommandPanel<WaypointNode> {
    public static final String VARIABLE_SELECTOR = "variableSelector.WaypointVariableTypePanel";
    private final ViewContext viewContext;
    private final VariableLookupService lookupService;
    private JLabel moveRobotHere;
    private JLabel useVariable;
    private JComboBox variableSelectorComboBox;
    private JLabel warningLabel;

    @Inject
    public WaypointVariableTypePanel(ViewContext viewContext, VariableLookupService lookupService) {
        super(WaypointNode.class);
        this.viewContext = viewContext;
        this.lookupService = lookupService;
        this.initComponents();
        this.variableSelectorComboBox.setName(VARIABLE_SELECTOR);
        this.finalizeComponents();
    }

    private void finalizeComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_waypoint_variable");
        ComboBoxRenderer.bindRenderer((JComboBox)this.variableSelectorComboBox, (RenderingStrategy)new VariableRenderingStrategy());
        this.warningLabel.setIcon(ViewImageResource.formWarning());
        this.warningLabel.setText(resource.notAValidPose());
        this.warningLabel.setVisible(false);
        this.moveRobotHere.setText(resource.moveTheRobotToAVariablePosition());
        this.useVariable.setText(resource.useVariable());
    }

    protected void updateCard() {
        VariableSet variables = this.lookupService.getAllProgramAndInstallationVariables();
        VariableComboBoxModel comboBoxModel = new VariableComboBoxModel();
        comboBoxModel.addElement((Object)((TextResource)this.viewContext.getTextResource(TextResource.class)).placeholderVariable());
        comboBoxModel.addVariables(this.getDefinedVariables((Iterable<Variable>)variables));
        if (((WaypointNode)this.getNode()).getInternalVariable() == null) {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        } else {
            comboBoxModel.selectVariable(((WaypointNode)this.getNode()).getInternalVariable());
        }
        this.variableSelectorComboBox.setModel(comboBoxModel);
        this.updateWarningLabel();
    }

    private void updateWarningLabel() {
        Object selectedItem = this.variableSelectorComboBox.getSelectedItem();
        if (selectedItem instanceof InstallationVariableReference) {
            boolean isPoseOrJointVector = ((InstallationVariableReference)selectedItem).isPoseOrJointVector();
            this.warningLabel.setVisible(!isPoseOrJointVector);
        } else {
            this.warningLabel.setVisible(false);
        }
    }

    public Collection<? extends Variable> getDefinedVariables(Iterable<Variable> variables) {
        return CollectionUtils.filter(variables, (Predicate)new Predicate<Variable>(){

            public boolean test(Variable variable) {
                if (variable instanceof GeomFeatureVariable) {
                    GeomFeatureVariable geomFeatureVariable = (GeomFeatureVariable)variable;
                    return !geomFeatureVariable.isUndefined() && !geomFeatureVariable.dereference().isUndefined();
                }
                return !variable.isUndefined();
            }
        });
    }

    private void initComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        JPanel jPanel3 = new JPanel();
        this.moveRobotHere = new JLabel();
        JPanel jPanel6 = new JPanel();
        this.useVariable = new JLabel();
        this.variableSelectorComboBox = new JComboBox();
        this.warningLabel = new JLabel();
        this.setLayout(new FlowLayout(0));
        jPanel3.setLayout(new GridLayout(3, 1));
        this.moveRobotHere.setText(resource.moveTheRobotToAVariablePosition());
        jPanel3.add(this.moveRobotHere);
        jPanel6.setLayout(new FlowLayout(2));
        this.useVariable.setText(resource.useVariable());
        jPanel6.add(this.useVariable);
        this.variableSelectorComboBox.setPreferredSize(new Dimension(180, 30));
        this.variableSelectorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaypointVariableTypePanel.this.variableSelectorComboBoxActionPerformed();
            }
        });
        jPanel6.add(this.variableSelectorComboBox);
        jPanel3.add(jPanel6);
        this.add(jPanel3);
        this.warningLabel.setText(resource.notAValidPose());
        this.add(this.warningLabel);
    }

    private void variableSelectorComboBoxActionPerformed() {
        if (this.getNode() == null) {
            Log.error((String)"WaypointVariableTypePanel.variableSelectorComboBoxActionPerformed() Error: waypointNode is null");
            return;
        }
        Object selectedItem = this.variableSelectorComboBox.getSelectedItem();
        ((WaypointNode)this.getNode()).setInternalVariable((Variable)(selectedItem instanceof Variable ? selectedItem : null));
        this.updateWarningLabel();
    }
}

