/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.wizards.infrastructure;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.util.logging.Log;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.commandpanels.wizards.NewSeekCard;
import gui.program.EntityFactory;
import gui.program.ProgramRootNode;
import gui.program.StackNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class NewSeekCardImpl
extends NewSeekCard {
    public static final String SEEK_DESTACK = "seek_destack.NewSeekCard";
    private final ViewContext viewContext;
    private final EntityFactory entityFactory;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private JButton destackButton;
    private JButton stackButton;

    @Inject
    NewSeekCardImpl(ViewContext viewContext, EntityFactory entityFactory, ControlProgramTreeStructure controlProgramTreeStructure) {
        this.viewContext = viewContext;
        this.entityFactory = entityFactory;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.initComponents();
        this.assignHelpIds();
        this.destackButton.setName(SEEK_DESTACK);
    }

    private void assignHelpIds() {
        HelpIdAssignerExt helpIdAssigner = this.viewContext.getHelpIdAssigner();
        helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:command_seek");
        helpIdAssigner.assignHelpId((JComponent)this.stackButton, "gui:command_stack");
        helpIdAssigner.assignHelpId((JComponent)this.destackButton, "gui:command_destack");
    }

    protected void updateCard() {
    }

    private void initComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.stackButton = new JButton(resource.Stacking());
        this.destackButton = new JButton(resource.Destacking());
        this.viewContext.createFormBuilder().headerLabel(resource.selectSeekType(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().description(resource.seekDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).end(5).label(resource.pleaseSelectBetweenStackingAndDestacking(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end(2).label(ProgramImageResource.stacking(), "", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER, FormBuilder.PanelConstraints.SPAN_12_ROWS}).spacer().label(ProgramImageResource.destacking(), "", new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER, FormBuilder.PanelConstraints.SPAN_12_ROWS}).end(12).spacer().end().component((JComponent)this.stackButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).spacer().component((JComponent)this.destackButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).spacer().end(3).groupColumns(new int[]{2}).groupColumns(new int[]{1, 3, 4}).setOnPanel((JPanel)((Object)this));
        this.stackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSeekCardImpl.this.entityFactory.setTypeAndAdjustNodes((StackNode)NewSeekCardImpl.this.getNode(), StackNode.Type.STACK);
                NewSeekCardImpl.this.updateCardAndShowNewChildren();
            }
        });
        this.destackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSeekCardImpl.this.entityFactory.setTypeAndAdjustNodes((StackNode)NewSeekCardImpl.this.getNode(), StackNode.Type.DESTACK);
                NewSeekCardImpl.this.updateCardAndShowNewChildren();
            }
        });
    }

    private void updateCardAndShowNewChildren() {
        StackNode node = (StackNode)this.getNode();
        try {
            this.switchTo(node.getCardClass(), node);
        }
        catch (Exception e) {
            Log.error((String)"Switching to something that was not a stacknode.", (Throwable)e);
        }
        if (node.getChildCount() != 0) {
            TreeNode o1 = node.getRoot();
            TreeNode o2 = node.getFirstChild();
            if (o1 instanceof ProgramRootNode && o2 instanceof AbstractProgramNode) {
                AbstractProgramNode programNode = (AbstractProgramNode)o2;
                this.controlProgramTreeStructure.makeVisible((TreeNode)programNode);
            }
        }
    }
}

