/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.wizards.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CompletedListener;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import gui.commandpanels.AccelerationFieldParser;
import gui.commandpanels.SpeedFieldParser;
import gui.commandpanels.wizards.SeekCard;
import gui.program.AccelerationValueNode;
import gui.program.SpeedValueNode;
import gui.program.StackNode;
import gui.program.validation.AccelerationValidationStrategyProvider;
import gui.program.validation.SpeedValidationStrategyProvider;
import gui.tools.DialogCreator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class SeekCardImpl
extends SeekCard {
    private static final double MAXIMUM_THICKNESS = 3000.0;
    private final ExpressionField exprEditorField;
    private final JPanel stackPanel;
    private final CardLayout topPanelLayout;
    private final SpeedValidationStrategyProvider speedValidationStrategyProvider;
    private final AccelerationValidationStrategyProvider accelerationValidationStrategyProvider;
    private final ViewContext viewContext;
    private final DialogCreator dialogCreator;
    private List<BindingRegistration> SpeedAccelerationbindingRegistrations = new ArrayList<BindingRegistration>();
    private JTextField accelerationField;
    private JPanel changeablePanel;
    private JTextField itemThicknessField;
    private JCheckBox sequenceActionCheckBox;
    private JCheckBox sequenceAfterEndCheckBox;
    private JTextField speedField;
    private ValidationStrategy thicknessValidator;
    private TextResource textResource;

    @Inject
    SeekCardImpl(ViewContext context, ExpressionField expEditor, SpeedValidationStrategyProvider speedValidationStrategyProvider, AccelerationValidationStrategyProvider accelerationValidationStrategyProvider, DialogCreator dialogCreator) {
        this.viewContext = context;
        this.exprEditorField = expEditor;
        this.textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.dialogCreator = dialogCreator;
        this.initComponents();
        this.stackPanel = context.createFormBuilder().headerLabel(((CommandNamesResource)context.getTextResource(CommandNamesResource.class)).Stack(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().spacer().end(3).description(ProgramImageResource.stacking(), this.textResource.stackingDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_12_ROWS}).end(12).getPanel();
        this.changeablePanel.add((Component)this.stackPanel, "stack");
        JPanel destackPanel = context.createFormBuilder().headerLabel(((CommandNamesResource)context.getTextResource(CommandNamesResource.class)).Destack(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().spacer().end(3).description(ProgramImageResource.destacking(), this.textResource.destackingDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_12_ROWS}).end(12).getPanel();
        this.changeablePanel.add((Component)destackPanel, "destack");
        this.topPanelLayout = (CardLayout)this.changeablePanel.getLayout();
        this.topPanelLayout.show(this.changeablePanel, "stack");
        this.speedValidationStrategyProvider = speedValidationStrategyProvider;
        this.accelerationValidationStrategyProvider = accelerationValidationStrategyProvider;
        this.bindNumberPickers();
        this.assignHelpIds();
    }

    private void bindNumberPickers() {
        this.thicknessValidator = ValidationFactory.getRangeValidator((double)0.0, (double)3000.0, (String)((TextResource)this.viewContext.getTextResource(TextResource.class)).valueOutOfRange(0.0, Units.getText().unitMm(), 3000.0));
        NumberFieldUtils.bindNumberPicker((JTextField)this.itemThicknessField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                SeekCardImpl.this.parseThicknessValue();
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveNumbers);
        NumberFieldUtils.bindErrorValidator((JTextField)this.itemThicknessField, (ValidationStrategy)this.thicknessValidator);
        NumberFieldUtils.bindNumberPicker((JTextField)this.speedField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                SpeedFieldParser.parse((JTextComponent)SeekCardImpl.this.speedField, (SpeedValueNode)((SpeedValueNode)SeekCardImpl.this.getNode()));
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveNumbers);
        NumberFieldUtils.bindNumberPicker((JTextField)this.accelerationField, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                AccelerationFieldParser.parse((JTextComponent)SeekCardImpl.this.accelerationField, (AccelerationValueNode)((AccelerationValueNode)SeekCardImpl.this.getNode()));
            }

            public void requestCancel() {
            }
        }, (Mode)Mode.PositiveNumbers);
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_seek");
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.stackPanel, "gui:command_stack");
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.stackPanel, "gui:command_destack");
    }

    protected void updateCard() {
        StackNode node = (StackNode)this.getNode();
        if (node.getType() == StackNode.Type.STACK) {
            this.topPanelLayout.show(this.changeablePanel, "stack");
        } else if (node.getType() == StackNode.Type.DESTACK) {
            this.topPanelLayout.show(this.changeablePanel, "destack");
        }
        this.exprEditorField.setNodeWithExpression((ExpressionNodeProperty)node);
        SpeedFieldParser.update((JTextComponent)this.speedField, (SpeedValueNode)node);
        AccelerationFieldParser.update((JTextComponent)this.accelerationField, (AccelerationValueNode)node);
        this.itemThicknessField.setText(Units.convert_from_m((double)node.getItemThickness()));
        this.sequenceActionCheckBox.setSelected(node.getHasBeforeStartSequence());
        this.sequenceAfterEndCheckBox.setSelected(node.getHasAfterEndSequence());
        for (BindingRegistration br : this.SpeedAccelerationbindingRegistrations) {
            br.removeRegistration();
        }
        if (node.isCartesianMotion()) {
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.speedField, (ValidationStrategy)this.speedValidationStrategyProvider.getCartesianJointSpeedLimitValidator()));
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.accelerationField, (ValidationStrategy)this.accelerationValidationStrategyProvider.getCartesianJointAccelerationLimitValidator()));
        } else {
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.speedField, (ValidationStrategy)this.speedValidationStrategyProvider.getJointSpeedLimitValidator()));
            this.SpeedAccelerationbindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)this.accelerationField, (ValidationStrategy)this.accelerationValidationStrategyProvider.getJointAccelerationLimitValidator()));
        }
    }

    private void parseThicknessValue() {
        if (this.thicknessValidator.isValid(this.itemThicknessField.getText())) {
            double thickness = Units.convert_to_m((String)this.itemThicknessField.getText());
            ((StackNode)this.getNode()).setItemThickness(thickness);
        } else {
            this.dialogCreator.showErrorDialog(new ErrorMessage(this.textResource.errorParseerror(), this.thicknessValidator.getErrorMessage(this.itemThicknessField.getText()), ""), null);
        }
    }

    private void resetToDefaultsButtonActionPerformed() {
        ((StackNode)this.getNode()).resetToDefaults();
        this.updateCard();
    }

    private void sequenceActionCheckBoxItemStateChanged(ItemEvent evt) {
        ((StackNode)this.getNode()).setHasBeforeStartSequence(evt.getStateChange() == 1);
        this.updateCard();
    }

    private void sequenceAfterEndCheckBoxItemStateChanged(ItemEvent evt) {
        ((StackNode)this.getNode()).setHasAfterEndSequence(evt.getStateChange() == 1);
        this.updateCard();
    }

    private void initComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.changeablePanel = new JPanel();
        JPanel alwaysPresentPanel = new JPanel();
        JPanel expressionPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JPanel jPanel1 = new JPanel();
        ExpressionField expressionTextField = this.exprEditorField;
        JPanel bottomPart = new JPanel();
        JPanel gridbagPanel = new JPanel();
        JLabel speedLabel = new JLabel();
        this.speedField = new JTextField();
        this.speedField.setFocusable(false);
        JLabel speedUnit = new JLabel();
        JLabel accelerationLabel = new JLabel();
        this.accelerationField = new JTextField();
        this.accelerationField.setFocusable(false);
        JLabel accelerationUnit = new JLabel();
        JButton resetToDefaultsButton = new JButton();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.itemThicknessField = new JTextField();
        this.itemThicknessField.setFocusable(false);
        JLabel itemThiknessUnit = new JLabel();
        JPanel jPanel4 = new JPanel();
        this.sequenceActionCheckBox = new JCheckBox();
        this.sequenceAfterEndCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.changeablePanel.setLayout(new CardLayout());
        this.add(this.changeablePanel, "Center");
        alwaysPresentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        alwaysPresentPanel.setLayout(new BorderLayout());
        expressionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 25, 5));
        expressionPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jLabel1.setText(resource.specifyWhenTheNextStackPositionIsReached());
        jPanel2.add(jLabel1);
        expressionPanel.add((Component)jPanel2, "North");
        jPanel1.setLayout(new BorderLayout());
        expressionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((StackNode)SeekCardImpl.this.getNode()).textHasChanged();
            }
        });
        expressionTextField.setHorizontalAlignment(0);
        expressionTextField.setPreferredSize(new Dimension(300, 28));
        jPanel1.add((Component)expressionTextField, "Center");
        expressionPanel.add((Component)jPanel1, "Center");
        alwaysPresentPanel.add((Component)expressionPanel, "North");
        bottomPart.setLayout(new BorderLayout(5, 5));
        gridbagPanel.setBorder(BorderFactory.createTitledBorder(resource.sharedParameters()));
        gridbagPanel.setMinimumSize(new Dimension(348, 98));
        gridbagPanel.setLayout(new GridBagLayout());
        speedLabel.setText(resource.toolSpeed());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridbagPanel.add((Component)speedLabel, gridBagConstraints);
        this.speedField.setHorizontalAlignment(11);
        this.speedField.setText("0.000");
        this.speedField.setPreferredSize(new Dimension(80, 27));
        this.speedField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SeekCardImpl.this.speedFieldFocusLost();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)this.speedField, gridBagConstraints);
        speedUnit.setText(Units.getText().unitMmS());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)speedUnit, gridBagConstraints);
        accelerationLabel.setText(resource.toolAcceleration());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridbagPanel.add((Component)accelerationLabel, gridBagConstraints);
        this.accelerationField.setHorizontalAlignment(11);
        this.accelerationField.setText("0.000");
        this.accelerationField.setPreferredSize(new Dimension(80, 27));
        this.accelerationField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SeekCardImpl.this.accelerationFieldFocusLost();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)this.accelerationField, gridBagConstraints);
        accelerationUnit.setText(Units.getText().unitMmS2());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridbagPanel.add((Component)accelerationUnit, gridBagConstraints);
        resetToDefaultsButton.setText(resource.resetToDefaults());
        resetToDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeekCardImpl.this.resetToDefaultsButtonActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridbagPanel.add((Component)resetToDefaultsButton, gridBagConstraints);
        bottomPart.add((Component)gridbagPanel, "East");
        jPanel3.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(resource.itemThikness()));
        this.itemThicknessField.setHorizontalAlignment(11);
        this.itemThicknessField.setText("0.000");
        this.itemThicknessField.setPreferredSize(new Dimension(80, 28));
        this.itemThicknessField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SeekCardImpl.this.itemThiknessFieldFocusLost();
            }
        });
        jPanel5.add(this.itemThicknessField);
        itemThiknessUnit.setText(Units.getText().unitMm());
        jPanel5.add(itemThiknessUnit);
        jPanel3.add((Component)jPanel5, "Center");
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        this.sequenceActionCheckBox.setText(resource.sequenceBeforeStart());
        this.sequenceActionCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SeekCardImpl.this.sequenceActionCheckBoxItemStateChanged(evt);
            }
        });
        jPanel4.add(this.sequenceActionCheckBox);
        this.sequenceAfterEndCheckBox.setText(resource.sequenceAfterEnd());
        this.sequenceAfterEndCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SeekCardImpl.this.sequenceAfterEndCheckBoxItemStateChanged(evt);
            }
        });
        jPanel4.add(this.sequenceAfterEndCheckBox);
        jPanel3.add((Component)jPanel4, "South");
        bottomPart.add((Component)jPanel3, "Center");
        alwaysPresentPanel.add((Component)bottomPart, "Center");
        this.add(alwaysPresentPanel, "South");
    }

    private void itemThiknessFieldFocusLost() {
        this.parseThicknessValue();
    }

    private void speedFieldFocusLost() {
        SpeedFieldParser.parse((JTextComponent)this.speedField, (SpeedValueNode)((SpeedValueNode)this.getNode()));
    }

    private void accelerationFieldFocusLost() {
        AccelerationFieldParser.parse((JTextComponent)this.accelerationField, (AccelerationValueNode)((AccelerationValueNode)this.getNode()));
    }
}

