/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.api.domain.io;

import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.util.Filter;

public class IOFilterFactory {
    public static Filter<IO> digitalFilter() {
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return element.getType() == IO.IOType.DIGITAL;
            }
        };
    }

    public static Filter<IO> integerFilter() {
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return element.getType() == IO.IOType.INTEGER;
            }
        };
    }

    public static Filter<IO> analogFilter() {
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return element.getType() == IO.IOType.ANALOG;
            }
        };
    }

    public static Filter<IO> toolFilter() {
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return element.getInterfaceType() == IO.InterfaceType.UR_TOOL;
            }
        };
    }

    public static Filter<IO> modbusFilter() {
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return element.getInterfaceType() == IO.InterfaceType.UR_MODBUS;
            }
        };
    }

    public static Filter<IO> inputFilter() {
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return element.isInput();
            }
        };
    }

    public static Filter<IO> outputFilter() {
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return !element.isInput();
            }
        };
    }

    public static Filter<IO> digitalInputFilter() {
        final Filter<IO> digitalFilter = IOFilterFactory.digitalFilter();
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return digitalFilter.accept((Object)element) && element.isInput();
            }
        };
    }

    public static Filter<IO> digitalOutputFilter() {
        final Filter<IO> digitalFilter = IOFilterFactory.digitalFilter();
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return digitalFilter.accept((Object)element) && !element.isInput();
            }
        };
    }

    public static Filter<IO> analogInputFilter() {
        final Filter<IO> analogFilter = IOFilterFactory.analogFilter();
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return analogFilter.accept((Object)element) && element.isInput();
            }
        };
    }

    public static Filter<IO> analogOutputFilter() {
        final Filter<IO> analogFilter = IOFilterFactory.analogFilter();
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return analogFilter.accept((Object)element) && !element.isInput();
            }
        };
    }

    public static Filter<IO> integerInputFilter() {
        final Filter<IO> integerFilter = IOFilterFactory.integerFilter();
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return integerFilter.accept((Object)element) && element.isInput();
            }
        };
    }

    public static Filter<IO> integerOutputFilter() {
        final Filter<IO> integerFilter = IOFilterFactory.integerFilter();
        return new Filter<IO>(){

            public boolean accept(IO element) {
                return integerFilter.accept((Object)element) && !element.isInput();
            }
        };
    }
}

