/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.java.logger;

import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.java.logger.ProxyLogger;
import java.util.ArrayList;
import java.util.List;

public abstract class LogFactory {
    private static final List<ProxyLogger> proxyLoggers = new ArrayList<ProxyLogger>();
    private static LogFactory logFactory;

    public abstract Logger internalCreateLogger(Class<?> var1);

    public abstract Logger internalCreateLogger(String var1);

    public static void setLogFactory(LogFactory logFactory) {
        LogFactory.logFactory = logFactory;
        if (logFactory == null) {
            return;
        }
        for (ProxyLogger each : proxyLoggers) {
            each.setRealLogger(logFactory);
        }
    }

    public static Logger createLogger(Class<?> clazz) {
        if (logFactory == null) {
            ProxyLogger result = new ProxyLogger(clazz);
            proxyLoggers.add(result);
            return result;
        }
        return logFactory.internalCreateLogger(clazz);
    }

    public static Logger createLogger(String name) {
        if (logFactory == null) {
            ProxyLogger result = new ProxyLogger(name);
            proxyLoggers.add(result);
            return result;
        }
        return logFactory.internalCreateLogger(name);
    }
}

