/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.application.XmlPrimitiveDataModel;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;

abstract class XmlPrimitiveArraysDataModel
extends XmlPrimitiveDataModel {
    public XmlPrimitiveArraysDataModel(PersistWriter writer) {
        super(writer);
    }

    public XmlPrimitiveArraysDataModel(PersistReader reader) {
        super(reader);
    }

    public void set(String s, boolean[] booleans) {
        this.writer.addAttribute(s, booleans);
    }

    public void set(String s, int[] ints) {
        this.writer.addAttribute(s, ints);
    }

    public void set(String s, double[] doubles) {
        this.writer.addAttribute(s, doubles);
    }

    public void set(String key, long[] values) {
        if (values == null) {
            return;
        }
        this.writer.addAttribute(key, StringUtils.joinStringsWith((String)", ", (long[])values));
    }

    public void set(String key, float[] values) {
        if (values == null) {
            return;
        }
        this.writer.addAttribute(key, StringUtils.joinStringsWith((String)", ", (float[])values));
    }

    public void set(String s, String[] values) {
        if (values == null) {
            return;
        }
        this.writer.addAttribute(s, values);
    }

    public boolean[] get(String s, boolean[] defaultValues) {
        boolean[] result = this.reader.getBooleanArrayAttribute(s);
        if (result == null) {
            return defaultValues;
        }
        return result;
    }

    public int[] get(String s, int[] defaultValues) {
        int[] result = this.reader.getIntegerArrayAttribute(s);
        if (result == null) {
            return defaultValues;
        }
        return result;
    }

    public long[] get(String key, long[] defaultValues) {
        String valuesAsString = this.reader.getStringAttribute(key);
        if (valuesAsString != null) {
            String[] values = StringUtils.split((String)", ", (String)valuesAsString);
            return PrimitiveUtils.parseLongArray((String[])values);
        }
        return defaultValues;
    }

    public float[] get(String key, float[] defaultValues) {
        String valuesAsString = this.reader.getStringAttribute(key);
        if (valuesAsString != null) {
            String[] values = StringUtils.split((String)", ", (String)valuesAsString);
            return PrimitiveUtils.parseFloatArray((String[])values);
        }
        return defaultValues;
    }

    public double[] get(String s, double[] defaultValues) {
        double[] result = this.reader.getDoubleArrayAttribute(s);
        if (result == null) {
            return defaultValues;
        }
        return result;
    }

    public String[] get(String key, String[] defaultValues) {
        String[] result = this.reader.getStringArray(key);
        if (result == null) {
            return defaultValues;
        }
        return result;
    }
}

