/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.application;

import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.urcap.api.domain.data.DataModel;

abstract class XmlPrimitiveDataModel
implements DataModel {
    protected final PersistWriter writer;
    protected final PersistReader reader;

    public XmlPrimitiveDataModel(PersistWriter writer) {
        this.writer = writer;
        this.reader = null;
    }

    public XmlPrimitiveDataModel(PersistReader reader) {
        this.writer = null;
        this.reader = reader;
    }

    public void set(String s, int i) {
        this.writer.addAttribute(s, i);
    }

    public void set(String s, boolean b) {
        this.writer.addAttribute(s, b);
    }

    public void set(String s, long l) {
        this.writer.addAttribute(s, String.valueOf(l));
    }

    public void set(String s, float v) {
        this.writer.addAttribute(s, String.valueOf(v));
    }

    public void set(String s, double v) {
        this.writer.addAttribute(s, v);
    }

    public void set(String s, String s1) {
        this.writer.addAttribute(s, s1);
    }

    public boolean get(String s, boolean b) {
        try {
            return this.reader.getBooleanAttribute(s, b);
        }
        catch (Exception exception) {
            return b;
        }
    }

    public int get(String s, int defaultValue) {
        try {
            return this.reader.getIntegerAttribute(s);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public long get(String s, long defaultValue) {
        try {
            return Long.parseLong(this.reader.getStringAttribute(s));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public float get(String s, float defaultValue) {
        return PrimitiveUtils.parseFloat((String)this.reader.getStringAttribute(s), (float)defaultValue);
    }

    public double get(String s, double defaultValue) {
        try {
            return this.reader.getDoubleAttribute(s);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public String get(String s, String defaultValue) {
        String result = this.reader.getStringAttribute(s);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }
}

