/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.robotstate.model.PayloadAttributesModel;
import com.ur.polyscope.payload.observers.ActivePayloadChanged;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ActivePayloadParameters {
    private PayloadComponent activePayload;
    private PayloadComponent lastActivePayload;

    @Inject
    public ActivePayloadParameters(@Source(value=PayloadAttributesModel.class) Recipe<PayloadAttributesModel> payloadRecipe) {
        payloadRecipe.subscribe((Consumer)new Consumer<PayloadAttributesModel>(){

            public void accept(PayloadAttributesModel payloadAttributesModel) {
                PayloadComponent receivedPayload = new PayloadComponent(payloadAttributesModel.mass, payloadAttributesModel.cog, payloadAttributesModel.inertiaMatrix);
                if (receivedPayload != ActivePayloadParameters.this.activePayload) {
                    ActivePayloadParameters.this.lastActivePayload = ActivePayloadParameters.this.activePayload;
                    ActivePayloadParameters.this.activePayload = receivedPayload;
                    ActivePayloadParameters.this.notifyActivePayloadModified(ActivePayloadParameters.this.lastActivePayload, ActivePayloadParameters.this.activePayload);
                }
            }
        });
    }

    public PayloadComponent getActivePayload() {
        return this.activePayload;
    }

    private void notifyActivePayloadModified(final PayloadComponent lastActivePayload, final PayloadComponent payloadComponent) {
        EventNotificationService.notify(ActivePayloadChanged.class, (NotificationStrategy)new NotificationStrategy<ActivePayloadChanged>(){

            public void notify(ActivePayloadChanged listener) {
                listener.activePayloadChanged(lastActivePayload, payloadComponent);
            }
        });
    }
}

