/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl;

import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationModifier;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.domain.PostCreateInstallation;
import com.ur.polyscope.installation.domain.PostSetInstallation;
import com.ur.polyscope.installation.domain.UnderWayInstallation;
import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.util.event.EventNotificationService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

@Singleton
public class PayloadServiceImpl
extends InstallationStateListener.Template
implements PayloadService,
UnderWayInstallation,
PostCreateInstallation,
PostSetInstallation {
    private final PayloadSettingProvider settingsProvider;
    private final InstallationModifier installationModifier;
    private final ArrayList<InstallationPayloadComponent> delayedPayloads = new ArrayList();
    private final Provider<NamingService> namingServiceProvider;
    private boolean delayCreation = false;

    @Inject
    public PayloadServiceImpl(PayloadSettingProvider settingsProvider, InstallationModifier installationModifier, Provider<NamingService> namingServiceProvider) {
        this.settingsProvider = settingsProvider;
        this.installationModifier = installationModifier;
        this.namingServiceProvider = namingServiceProvider;
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)((Object)this));
    }

    protected boolean isDelayed() {
        return this.delayCreation;
    }

    public void installationUnderWay(Installation robotInstallation) {
        this.delayCreation = true;
        this.startDelayCreation();
    }

    public void postLoad(Installation newInstallation) {
        this.delayCreation = false;
        this.stopDelayCreation();
    }

    public void installationLoadFailed() {
        this.delayCreation = false;
        this.delayCreationFailed();
    }

    public void postCreate(Installation installation) {
        this.createDefaultPayload();
    }

    private void createDefaultPayload() {
        this.delayedPayloads.add(0, new InstallationPayloadComponent("Payload"));
    }

    public InstallationPayloadComponent addPayload(String name, Weight mass, Vector3d centerOfGravity, Matrix3d inertia) {
        PayloadComponent newPayload = new PayloadComponent(mass, centerOfGravity, inertia, true);
        return this.doAddPayload(name, newPayload, InstallationPayloadComponent.UNKNOWN, true);
    }

    public InstallationPayloadComponent addPayload(String name, Weight mass, Vector3d centerOfGravity, Matrix3d inertia, ContributorInfo contributorInfo) {
        Weight massRoundUp = this.roundUpMass(mass);
        PayloadComponent newPayload = new PayloadComponent(massRoundUp, centerOfGravity, inertia);
        return this.doAddPayload(name, newPayload, contributorInfo, true);
    }

    public InstallationPayloadComponent addPayload(String name, Weight mass, Vector3d centerOfGravity, ContributorInfo contributorInfo) {
        Weight massRoundUp = this.roundUpMass(mass);
        PayloadComponent newPayload = new PayloadComponent(massRoundUp, centerOfGravity, new Matrix3d());
        return this.doAddPayload(name, newPayload, contributorInfo, false);
    }

    private InstallationPayloadComponent doAddPayload(String name, PayloadComponent newPayload, ContributorInfo contributorInfo, boolean customInertia) {
        if (!this.isDelayed()) {
            return this.settingsProvider.get().addPayload(name, newPayload, contributorInfo, customInertia);
        }
        InstallationPayloadComponent delayedPayload = new InstallationPayloadComponent(name, newPayload, contributorInfo, customInertia);
        this.delayedPayloads.add(delayedPayload);
        return delayedPayload;
    }

    public boolean removePayload(InstallationPayloadComponent installationPayloadComponent) {
        return this.settingsProvider.get().removePayload(installationPayloadComponent);
    }

    public boolean removeDelayedPayload(InstallationPayloadComponent installationPayloadComponent) {
        return this.delayedPayloads.remove(installationPayloadComponent);
    }

    public InstallationPayloadComponent getPayloadByContributorInfo(ContributorInfo contributorInfo) {
        return this.settingsProvider.get().getPayloadByContributionInfo(contributorInfo);
    }

    public InstallationPayloadComponent getDelayedPayloadByContributorInfo(ContributorInfo contributorInfo) {
        for (InstallationPayloadComponent delayedPayload : this.delayedPayloads) {
            ContributorInfo info = delayedPayload.getContributorInfo();
            if (info == null || !info.getOwnerId().equals(contributorInfo.getOwnerId()) || !info.getId().equals(contributorInfo.getId())) continue;
            return delayedPayload;
        }
        return null;
    }

    public void setInstallationDefaultPayload(InstallationPayloadComponent payloadComponent) {
        this.settingsProvider.get().setAsInstallationDefaultPayload(payloadComponent);
    }

    public InstallationPayloadComponent getInstallationDefaultPayload() {
        return this.settingsProvider.get().getInstallationDefaultPayload();
    }

    public void removeURCapsPayloadsWithOwnerId(String ownerId) {
        List allPayloads = this.settingsProvider.get().getAllPayloads();
        for (InstallationPayloadComponent each : allPayloads) {
            if (!each.getContributorInfo().getOwnerId().equals(ownerId)) continue;
            this.removePayload(each);
        }
        Iterator<InstallationPayloadComponent> iterator = this.delayedPayloads.iterator();
        while (iterator.hasNext()) {
            InstallationPayloadComponent next = iterator.next();
            if (!next.getContributorInfo().getOwnerId().equals(ownerId)) continue;
            iterator.remove();
        }
    }

    public PayloadComponent getActivePayload() {
        return this.settingsProvider.get().getActivePayload();
    }

    public InstallationPayloadComponent getPayloadByName(String name) {
        return this.settingsProvider.get().getPayloadByName(name);
    }

    public List<InstallationPayloadComponent> getAllPayloads() {
        return this.settingsProvider.get().getAllPayloads();
    }

    public InstallationPayloadComponent addPayloadWithoutDelay(String name, Weight mass, Vector3d centerOfGravity, Matrix3d inertia) {
        PayloadComponent newPayload = new PayloadComponent(mass, centerOfGravity, inertia, true);
        return this.settingsProvider.get().addPayload(name, newPayload, InstallationPayloadComponent.UNKNOWN, true);
    }

    private Weight roundUpMass(Weight mass) {
        ValueConverter weightConverter = UnitsValueConverterFactory.getWeightConverter();
        String massFormatted = weightConverter.getFormat().format(Double.parseDouble((String)weightConverter.fromModel((Object)mass)));
        return (Weight)weightConverter.fromGui((Object)massFormatted);
    }

    private void startDelayCreation() {
        this.delayedPayloads.clear();
    }

    private void stopDelayCreation() {
        this.processDelayedPayloads();
    }

    private void delayCreationFailed() {
        this.delayedPayloads.clear();
    }

    private void processDelayedPayloads() {
        for (InstallationPayloadComponent delayedPayload : this.delayedPayloads) {
            String name = ((NamingService)this.namingServiceProvider.get()).makeUniqueName(InstallationPayloadComponent.class, delayedPayload.getName());
            this.settingsProvider.get().addPayload(name, new PayloadComponent(delayedPayload.getMass(), delayedPayload.getCenterOfGravity(), delayedPayload.getInertiaMatrix()), delayedPayload.getContributorInfo(), delayedPayload.isCustomInertiaEnabled());
            this.installationModifier.makeDirty();
        }
        this.delayedPayloads.clear();
    }

    public static class PayloadSettingProvider
    implements Provider<PayloadSettings> {
        private final UnderwayInstallationProvider underwayInstallationProvider;

        @Inject
        PayloadSettingProvider(UnderwayInstallationProvider underwayInstallationProvider) {
            this.underwayInstallationProvider = underwayInstallationProvider;
        }

        public PayloadSettings get() {
            return (PayloadSettings)this.underwayInstallationProvider.getUnderwayInstallation().getComponent(PayloadSettings.class);
        }
    }
}

