/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl;

import com.google.common.collect.ImmutableList;
import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.payload.PayloadModificationObserver;
import com.ur.polyscope.payload.PayloadObserver;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.impl.ActivePayloadParameters;
import com.ur.polyscope.payload.impl.PayloadSettingsImpl$AjcClosure1;
import com.ur.polyscope.payload.impl.PayloadSettingsImpl$AjcClosure3;
import com.ur.polyscope.payload.impl.PayloadSettingsImpl$AjcClosure5;
import com.ur.polyscope.payload.impl.PayloadSettingsImpl$AjcClosure7;
import com.ur.polyscope.payload.impl.common.domain.SphereOfWaterInertia;
import com.ur.polyscope.payload.impl.installation.PayloadReferenceHandlingStrategy;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.reference.ReferenceHandlingStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class PayloadSettingsImpl
implements PayloadSettings {
    private final NamingService namingService;
    private final List<InstallationPayloadComponent> allPayloads = Collections.synchronizedList(new ArrayList());
    private final ActivePayloadParameters activePayloadParameters;
    private final PayloadReferenceHandlingStrategy payloadReferenceHandlingStrategy;
    private InstallationPayloadComponent defaultInstallationPayload;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Inject
    public PayloadSettingsImpl(NamingService namingService, ActivePayloadParameters activePayloadParameters, PayloadReferenceHandlingStrategy payloadReferenceHandlingStrategy) {
        this.namingService = namingService;
        this.activePayloadParameters = activePayloadParameters;
        this.payloadReferenceHandlingStrategy = payloadReferenceHandlingStrategy;
    }

    public ReferenceHandlingStrategy<String, InstallationPayloadComponent, PayloadReferenceComponent> getPayloadReferenceHandlingStrategy() {
        return this.payloadReferenceHandlingStrategy;
    }

    public InstallationPayloadComponent addPayload() {
        String name = this.namingService.makeUniqueName(InstallationPayloadComponent.class, "Payload");
        return this.addPayload(name, PayloadComponent.ZERO_PAYLOAD, InstallationPayloadComponent.UNKNOWN, false);
    }

    public InstallationPayloadComponent addPayload(String name) {
        return this.addPayload(name, PayloadComponent.ZERO_PAYLOAD, InstallationPayloadComponent.UNKNOWN, false);
    }

    public InstallationPayloadComponent addPayload(String name, PayloadComponent basicPayload) {
        return this.addPayload(name, basicPayload, InstallationPayloadComponent.UNKNOWN, false);
    }

    public InstallationPayloadComponent addPayload(String name, PayloadComponent basicPayload, ContributorInfo contributorInfo) {
        return this.addPayload(name, basicPayload, contributorInfo, false);
    }

    public InstallationPayloadComponent addPayload(String name, PayloadComponent basicPayload, ContributorInfo contributorInfo, boolean customInertiaEnabled) {
        boolean setDefaultPayload = this.allPayloads.isEmpty();
        InstallationPayloadComponent payload = this.getInstallationPayloadComponent(name, basicPayload, contributorInfo, customInertiaEnabled);
        this.namingService.registerNamedEntity((NamedEntity)payload);
        this.addPayloadAndNotify(payload);
        if (setDefaultPayload) {
            this.setAsInstallationDefaultPayload(payload);
        }
        return payload;
    }

    private InstallationPayloadComponent getInstallationPayloadComponent(String name, PayloadComponent basicPayload, ContributorInfo contributorInfo, boolean customInertiaEnabled) {
        Weight weight = basicPayload.getMass();
        Vector3d cog = basicPayload.getCenterOfGravity();
        Matrix3d inertia = basicPayload.getInertiaMatrix();
        if (!customInertiaEnabled) {
            inertia = SphereOfWaterInertia.getInertiaMatrix(weight.asDouble());
        }
        return new InstallationPayloadComponent(name, new PayloadComponent(weight, cog, inertia), contributorInfo, customInertiaEnabled);
    }

    @InstallationChangedEvent
    private boolean addPayloadAndNotify(InstallationPayloadComponent payload) {
        InstallationPayloadComponent installationPayloadComponent = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)installationPayloadComponent);
        Object[] objectArray = new Object[]{this, installationPayloadComponent, joinPoint};
        PayloadSettingsImpl$AjcClosure1 payloadSettingsImpl$AjcClosure1 = new PayloadSettingsImpl$AjcClosure1(objectArray);
        return Conversions.booleanValue((Object)InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(payloadSettingsImpl$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    @InstallationChangedEvent
    public InstallationPayloadComponent updatePayloadParameters(InstallationPayloadComponent updatedPayloadConfiguration) {
        InstallationPayloadComponent installationPayloadComponent = updatedPayloadConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)installationPayloadComponent);
        Object[] objectArray = new Object[]{this, installationPayloadComponent, joinPoint};
        PayloadSettingsImpl$AjcClosure3 payloadSettingsImpl$AjcClosure3 = new PayloadSettingsImpl$AjcClosure3(objectArray);
        return (InstallationPayloadComponent)InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(payloadSettingsImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public InstallationPayloadComponent getPayloadByName(String name) {
        for (InstallationPayloadComponent each : this.allPayloads) {
            if (!EqualsUtil.equals((Object)name, (Object)each.getName())) continue;
            return each;
        }
        return null;
    }

    public InstallationPayloadComponent getPayloadByContributionInfo(ContributorInfo contributorInfo) {
        for (InstallationPayloadComponent each : this.allPayloads) {
            if (!EqualsUtil.equals((Object)contributorInfo, (Object)each.getContributorInfo())) continue;
            return each;
        }
        return null;
    }

    public List<InstallationPayloadComponent> getAllPayloads() {
        Collections.sort(this.allPayloads, new PayloadComparator());
        return ImmutableList.copyOf(this.allPayloads);
    }

    public List<InstallationPayloadComponent> getPayloadsByContributorInfo(ContributorInfo contributorInfo) {
        ArrayList<InstallationPayloadComponent> payloads = new ArrayList<InstallationPayloadComponent>();
        for (InstallationPayloadComponent payload : this.allPayloads) {
            if (!contributorInfo.equals(payload.getContributorInfo())) continue;
            payloads.add(payload);
        }
        return payloads;
    }

    @InstallationChangedEvent
    public boolean removePayload(InstallationPayloadComponent payload) {
        InstallationPayloadComponent installationPayloadComponent = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)installationPayloadComponent);
        Object[] objectArray = new Object[]{this, installationPayloadComponent, joinPoint};
        PayloadSettingsImpl$AjcClosure5 payloadSettingsImpl$AjcClosure5 = new PayloadSettingsImpl$AjcClosure5(objectArray);
        return Conversions.booleanValue((Object)InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(payloadSettingsImpl$AjcClosure5.linkClosureAndJoinPoint(69648)));
    }

    private void setNewDefaultPayload(InstallationPayloadComponent payload) {
        if (EqualsUtil.equals((Object)payload, (Object)this.getInstallationDefaultPayload())) {
            this.allPayloads.stream().findFirst().ifPresent(this::setAsInstallationDefaultPayload);
        }
    }

    @InstallationChangedEvent
    public boolean setAsInstallationDefaultPayload(InstallationPayloadComponent payload) {
        InstallationPayloadComponent installationPayloadComponent = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)installationPayloadComponent);
        Object[] objectArray = new Object[]{this, installationPayloadComponent, joinPoint};
        PayloadSettingsImpl$AjcClosure7 payloadSettingsImpl$AjcClosure7 = new PayloadSettingsImpl$AjcClosure7(objectArray);
        return Conversions.booleanValue((Object)InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(payloadSettingsImpl$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    private boolean isPayloadNotAlreadyTheDefaultAndHasItBeenAddedToPayloadList(InstallationPayloadComponent payload) {
        return Objects.nonNull(payload) && !EqualsUtil.equals((Object)this.defaultInstallationPayload, (Object)payload) && this.allPayloads.contains(payload);
    }

    public InstallationPayloadComponent getInstallationDefaultPayload() {
        return this.defaultInstallationPayload;
    }

    public PayloadComponent getActivePayload() {
        PayloadComponent basicPayloadParams = this.activePayloadParameters.getActivePayload();
        if (basicPayloadParams == null) {
            Log.warning((String)"Active payload has not been received yet");
            return null;
        }
        for (InstallationPayloadComponent each : this.allPayloads) {
            PayloadComponent eachBasic = new PayloadComponent(each.getMass(), each.getCenterOfGravity(), each.getInertiaMatrix());
            if (!eachBasic.equals((Object)basicPayloadParams)) continue;
            return each;
        }
        return basicPayloadParams;
    }

    public Class<?> getType() {
        return PayloadSettings.class;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter scriptWriter, ScriptGeneratorLookup scriptGeneratorLookup) {
        if (this.defaultInstallationPayload != null) {
            this.defaultInstallationPayload.writeScript(scriptWriter);
        }
    }

    private void firePayloadModificationEvent() {
        EventNotificationService.notify(PayloadModificationObserver.class, listener -> listener.modified(this.defaultInstallationPayload));
    }

    static {
        PayloadSettingsImpl.ajc$preClinit();
    }

    static final /* synthetic */ boolean addPayloadAndNotify_aroundBody0(PayloadSettingsImpl ajc$this, InstallationPayloadComponent payload, JoinPoint joinPoint) {
        boolean isAdded = ajc$this.allPayloads.add(payload);
        if (isAdded) {
            EventNotificationService.notify(PayloadObserver.class, listener -> listener.added(payload));
        }
        return isAdded;
    }

    static final /* synthetic */ InstallationPayloadComponent updatePayloadParameters_aroundBody2(PayloadSettingsImpl ajc$this, InstallationPayloadComponent updatedPayloadConfiguration, JoinPoint joinPoint) {
        InstallationPayloadComponent existingPayloadConfiguration = ajc$this.getPayloadByName(updatedPayloadConfiguration.getName());
        ajc$this.namingService.deregisterNamedEntity((NamedEntity)existingPayloadConfiguration);
        ajc$this.namingService.registerNamedEntity((NamedEntity)updatedPayloadConfiguration);
        ajc$this.allPayloads.remove(existingPayloadConfiguration);
        ajc$this.allPayloads.add(updatedPayloadConfiguration);
        if (EqualsUtil.equals((Object)ajc$this.defaultInstallationPayload, (Object)existingPayloadConfiguration)) {
            ajc$this.defaultInstallationPayload = updatedPayloadConfiguration;
        }
        EventNotificationService.notify(PayloadModificationObserver.class, listener -> listener.modified(updatedPayloadConfiguration));
        return updatedPayloadConfiguration;
    }

    static final /* synthetic */ boolean removePayload_aroundBody4(PayloadSettingsImpl ajc$this, InstallationPayloadComponent payload, JoinPoint joinPoint) {
        if (payload.getContributorInfo().equals(InstallationPayloadComponent.UNKNOWN) && ajc$this.getPayloadsByContributorInfo(InstallationPayloadComponent.UNKNOWN).size() <= 1) {
            Log.error((String)"Cannot remove payload, it's the only user defined one");
            return false;
        }
        if (ajc$this.allPayloads.size() <= 1) {
            Log.error((String)"Cannot remove payload, it's the only one defined");
            return false;
        }
        ajc$this.namingService.deregisterNamedEntity((NamedEntity)payload);
        boolean isRemoved = ajc$this.allPayloads.remove(payload);
        if (isRemoved) {
            ajc$this.setNewDefaultPayload(payload);
            EventNotificationService.notify(PayloadObserver.class, listener -> listener.removed(payload));
        }
        return isRemoved;
    }

    static final /* synthetic */ boolean setAsInstallationDefaultPayload_aroundBody6(PayloadSettingsImpl ajc$this, InstallationPayloadComponent payload, JoinPoint joinPoint) {
        if (ajc$this.isPayloadNotAlreadyTheDefaultAndHasItBeenAddedToPayloadList(payload)) {
            ajc$this.defaultInstallationPayload = payload;
            ajc$this.firePayloadModificationEvent();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PayloadSettingsImpl.java", PayloadSettingsImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addPayloadAndNotify", "com.ur.polyscope.payload.impl.PayloadSettingsImpl", "com.ur.polyscope.payload.common.InstallationPayloadComponent", "payload", "", "boolean"), 124);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updatePayloadParameters", "com.ur.polyscope.payload.impl.PayloadSettingsImpl", "com.ur.polyscope.payload.common.InstallationPayloadComponent", "updatedPayloadConfiguration", "", "com.ur.polyscope.payload.common.InstallationPayloadComponent"), 134);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removePayload", "com.ur.polyscope.payload.impl.PayloadSettingsImpl", "com.ur.polyscope.payload.common.InstallationPayloadComponent", "payload", "", "boolean"), 186);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAsInstallationDefaultPayload", "com.ur.polyscope.payload.impl.PayloadSettingsImpl", "com.ur.polyscope.payload.common.InstallationPayloadComponent", "payload", "", "boolean"), 216);
    }

    private static class PayloadComparator
    implements Serializable,
    Comparator<InstallationPayloadComponent> {
        private PayloadComparator() {
        }

        @Override
        public int compare(InstallationPayloadComponent o1, InstallationPayloadComponent o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

