/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.domain;

import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.visualizer.utils.Pose6dTransformUtils;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class InertiaDecomposition {
    private static final double[][] INVERSION_MATRIX_VALUES = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}};
    private static final RealMatrix INVERSION_REALMATRIX = MatrixUtils.createRealMatrix((double[][])INVERSION_MATRIX_VALUES);
    private static final Matrix3d ZERO_MATRIX = new Matrix3d();
    private final Vector3d rotation;
    private final double e1;
    private final double e2;
    private final double e3;
    private final double z;
    private final double y;
    private final double x;
    private final PayloadComponent payloadComponent;

    public InertiaDecomposition(PayloadComponent payloadComponent) {
        this.payloadComponent = payloadComponent;
        SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix3dToRealMatrix(payloadComponent.getInertiaMatrix()));
        LUDecomposition luDecomposition = new LUDecomposition(svd.getU());
        RealMatrix rotationMatrix = luDecomposition.getDeterminant() < 0.0 ? svd.getU().multiply(INVERSION_REALMATRIX) : svd.getU();
        this.rotation = Pose6dTransformUtils.getRotationVector((Matrix3d)this.realMatrixToMatrix3d(rotationMatrix));
        double[] s = svd.getSingularValues();
        this.e1 = s[0];
        this.e2 = s[1];
        this.e3 = s[2];
        double m = payloadComponent.getMass().asDouble();
        this.z = Math.sqrt(0.5 * (-this.e3 / (m / 5.0) + this.e1 / (m / 5.0) + this.e2 / (m / 5.0)));
        this.y = Math.sqrt(this.e1 / (m / 5.0) - this.z * this.z);
        this.x = Math.sqrt(this.e2 / (m / 5.0) - this.z * this.z);
    }

    public static boolean isValid(PayloadComponent payloadComponent) {
        return new InertiaDecomposition(payloadComponent).isValid();
    }

    private RealMatrix matrix3dToRealMatrix(Matrix3d inertiaMatrix) {
        double[][] result = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                result[i][j] = inertiaMatrix.getElement(i, j);
                ++j;
            }
            ++i;
        }
        return MatrixUtils.createRealMatrix((double[][])result);
    }

    private Matrix3d realMatrixToMatrix3d(RealMatrix realMatrix) {
        double[] result = new double[9];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                result[i * 3 + j] = realMatrix.getEntry(i, j);
                ++j;
            }
            ++i;
        }
        return new Matrix3d(result);
    }

    public boolean isValid() {
        return this.isZeroInertia() || this.isPositiveMassAndValidInertia();
    }

    private boolean isPositiveMassAndValidInertia() {
        return this.isEigenvalueValid() && this.isRotationValid() && this.isXYZValid() && this.isDiagonalsPositive() && !this.isZeroInertia();
    }

    private boolean isZeroInertia() {
        return this.payloadComponent.getInertiaMatrix().equals(ZERO_MATRIX);
    }

    private boolean isEigenvalueValid() {
        return this.e1 * this.e2 * this.e3 >= 0.0;
    }

    private boolean isRotationValid() {
        return !Double.isNaN(this.rotation.getX()) && !Double.isNaN(this.rotation.getY()) && !Double.isNaN(this.rotation.getZ());
    }

    private boolean isXYZValid() {
        return this.x >= 0.0 && this.y >= 0.0 && this.z >= 0.0;
    }

    private boolean isDiagonalsPositive() {
        Matrix3d inertia = this.payloadComponent.getInertiaMatrix();
        return inertia.getM00() >= 0.0 && inertia.getM11() >= 0.0 && inertia.getM22() >= 0.0;
    }

    public Vector3d getRotation() {
        return new Vector3d(this.rotation);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

