/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.domain;

import com.ur.urcap.api.domain.value.dynamics.InertiaMatrix;
import com.ur.urcap.api.domain.value.simple.MomentOfInertia;
import javax.vecmath.Matrix3d;

public final class InertiaMatrixToMatrixConverter {
    private InertiaMatrixToMatrixConverter() {
    }

    public static Matrix3d convertInertiaMatrixToMatrix3d(InertiaMatrix inertiaMatrix) {
        Matrix3d matrix = new Matrix3d();
        if (inertiaMatrix == null) {
            return matrix;
        }
        double xx = inertiaMatrix.getIxxComponent(MomentOfInertia.Unit.KG_M2);
        double yy = inertiaMatrix.getIyyComponent(MomentOfInertia.Unit.KG_M2);
        double zz = inertiaMatrix.getIzzComponent(MomentOfInertia.Unit.KG_M2);
        double xy = inertiaMatrix.getIxyComponent(MomentOfInertia.Unit.KG_M2);
        double xz = inertiaMatrix.getIxzComponent(MomentOfInertia.Unit.KG_M2);
        double yz = inertiaMatrix.getIyzComponent(MomentOfInertia.Unit.KG_M2);
        matrix.m00 = xx;
        matrix.m01 = xy;
        matrix.m02 = xz;
        matrix.m10 = xy;
        matrix.m11 = yy;
        matrix.m12 = yz;
        matrix.m20 = xz;
        matrix.m21 = yz;
        matrix.m22 = zz;
        return matrix;
    }
}

