/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.domain;

import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadValidationRules;
import com.ur.polyscope.payload.impl.common.domain.CogDistanceValidatorFactory;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.payload.impl.common.domain.InertiaMatrixToMatrixConverter;
import com.ur.polyscope.payload.impl.common.domain.MomentOfInertiaValidationFactory;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotPayload;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningProvider;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.PayloadValidation;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.dynamics.InertiaMatrix;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.MomentOfInertia;
import com.ur.urcap.api.domain.value.simple.Time;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

@Singleton
public class PayloadValidationRulesImpl
implements PayloadValidationRules {
    private static final ValueConverter<String, Weight> MASS_CONVERTER = UnitsValueConverterFactory.getWeightConverter();
    private final Provider<PayloadValidation> payloadValidationProvider;
    private final RobotConfigurationProvider robotConfigurationProvider;
    private final CogDistanceValidatorFactory cogRangeValidatorFactory;
    private final PayloadAndCogWarningProvider payloadAndCogWarningCalculator;
    private final MomentOfInertiaValidationFactory momentOfInertiaValidationFactory;

    @Inject
    public PayloadValidationRulesImpl(Provider<PayloadValidation> payloadValidationProvider, RobotConfigurationProvider robotConfigurationProvider, CogDistanceValidatorFactory cogRangeValidatorFactory, PayloadAndCogWarningProvider payloadAndCogWarningCalculator, MomentOfInertiaValidationFactory momentOfInertiaValidationFactory) {
        this.payloadValidationProvider = payloadValidationProvider;
        this.robotConfigurationProvider = robotConfigurationProvider;
        this.cogRangeValidatorFactory = cogRangeValidatorFactory;
        this.payloadAndCogWarningCalculator = payloadAndCogWarningCalculator;
        this.momentOfInertiaValidationFactory = momentOfInertiaValidationFactory;
    }

    public boolean isMassAboveUpperHardLimit(Mass mass) {
        double massInUserUnitSystem = mass.getAs(UnitsValueConverterFactory.getUnitType().isUS() ? Mass.Unit.LB : Mass.Unit.KG);
        if (massInUserUnitSystem <= 0.0) {
            return false;
        }
        AutoCorrectionValidator validator = ((PayloadValidation)this.payloadValidationProvider.get()).getPayloadValidator(true, false);
        return !validator.isValid(String.valueOf(massInUserUnitSystem));
    }

    public boolean isMassAboveUpperSoftLimit(Mass mass) {
        double massInUserUnitSystem = mass.getAs(UnitsValueConverterFactory.getUnitType().isUS() ? Mass.Unit.LB : Mass.Unit.KG);
        if (massInUserUnitSystem <= 0.0) {
            return false;
        }
        AutoCorrectionValidator validator = ((PayloadValidation)this.payloadValidationProvider.get()).getPayloadValidator(false, false);
        return !validator.isValid(String.valueOf(massInUserUnitSystem));
    }

    public boolean isMassZero(Mass mass) {
        double massKg = mass.getAs(Mass.Unit.KG);
        return Math.abs(massKg) < 9.9E-324;
    }

    public boolean isMassBelowZeroHardLimit(Mass mass) {
        double massKg = mass.getAs(Mass.Unit.KG);
        return massKg < 0.0;
    }

    public String getMassOutOfHardLimitsExceptionMessage(Mass mass) {
        RobotPayload robotPayload = this.robotConfigurationProvider.getRobotPayload();
        double maxRated = robotPayload.getMaximumPayload(false).getIn(Weight.Unit.SI);
        double maxUnRated = robotPayload.getMaximumPayload(true).getIn(Weight.Unit.SI);
        String maxRatedString = PayloadValidationRulesImpl.getMassString(Weight.from((double)maxRated, (Weight.Unit)Weight.Unit.SI));
        String maxUnratedString = PayloadValidationRulesImpl.getMassString(Weight.from((double)maxUnRated, (Weight.Unit)Weight.Unit.SI));
        String actualValueProvided = "'" + PayloadValidationRulesImpl.getMassString((Weight)mass) + "' " + MASS_CONVERTER.getUnit();
        return String.format("Invalid payload mass of %s specified. Value must be in the range [%s, %s] %s . Note the range [%s, %s] %s is unrated.", actualValueProvided, "0", maxUnratedString, MASS_CONVERTER.getUnit(), maxRatedString, maxUnratedString, MASS_CONVERTER.getUnit());
    }

    private static String getMassString(Weight mass) {
        String massString = MASS_CONVERTER.getFormat().format(Double.parseDouble((String)MASS_CONVERTER.fromModel((Object)mass)));
        if ("-0.000".equals(massString) || "0.000".equals(massString) || "-0,000".equals(massString) || "0,000".equals(massString)) {
            return "0";
        }
        return massString;
    }

    public boolean isCenterOfGravityOutOfRange(Position centerOfGravity) {
        Length.Unit userDefinedUnit;
        ValidationStrategy validator = this.cogRangeValidatorFactory.getRangeValidator();
        Length.Unit unit = userDefinedUnit = UnitsValueConverterFactory.getUnitType().isUS() ? Length.Unit.IN : Length.Unit.M;
        if (!validator.isValid(PayloadValidationRulesImpl.convertToString(centerOfGravity.getX(userDefinedUnit)))) {
            return true;
        }
        if (!validator.isValid(PayloadValidationRulesImpl.convertToString(centerOfGravity.getY(userDefinedUnit)))) {
            return true;
        }
        return !validator.isValid(PayloadValidationRulesImpl.convertToString(centerOfGravity.getZ(userDefinedUnit)));
    }

    private static String convertToString(double valueInMeters) {
        Length x = Length.from((double)valueInMeters, (Length.Unit)Length.Unit.M);
        return (String)UnitsValueConverterFactory.getLengthConverter().fromModel((Object)x);
    }

    public String getCenterOfGravityOutOfRangeExceptionMessage(Position centerOfGravity) {
        return "The values of the specified center of gravity are not inside the valid range.";
    }

    public boolean isMassAndCOGValid(Mass mass, Position centerOfGravity) {
        Weight weight = (Weight)mass;
        Vector3d vec = new Vector3d(centerOfGravity.getX(Length.Unit.M), centerOfGravity.getY(Length.Unit.M), centerOfGravity.getZ(Length.Unit.M));
        Length length = Length.from((double)vec.length(), (Length.Unit)Length.Unit.M);
        return this.payloadAndCogWarningCalculator.getPayloadAndCogWarning().isPayloadAndCogValid(weight, length);
    }

    public boolean isMassAndCOGValid(Mass mass, Vector3d cogVector) {
        Weight weight = (Weight)mass;
        Length length = Length.from((double)cogVector.length(), (Length.Unit)Length.Unit.M);
        return this.payloadAndCogWarningCalculator.getPayloadAndCogWarning().isPayloadAndCogValid(weight, length);
    }

    public boolean isMassAndCOGAndInertiaValid(Mass mass, Position centerOfGravity, InertiaMatrix inertia) {
        Vector3d cogVector = new Vector3d(centerOfGravity.getX(Length.Unit.M), centerOfGravity.getY(Length.Unit.M), centerOfGravity.getZ(Length.Unit.M));
        Matrix3d inertiaMatrix = InertiaMatrixToMatrixConverter.convertInertiaMatrixToMatrix3d(inertia);
        PayloadComponent payloadComponent = new PayloadComponent((Weight)mass, cogVector, inertiaMatrix, true);
        return InertiaDecomposition.isValid(payloadComponent);
    }

    public boolean isMassAndCOGAndInertiaValid(Mass mass, Vector3d cogVector, Matrix3d inertiaMatrix) {
        PayloadComponent payloadComponent = new PayloadComponent((Weight)mass, cogVector, inertiaMatrix, true);
        InertiaDecomposition decomposition = new InertiaDecomposition(payloadComponent);
        return decomposition.isValid();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInertiaOutOfRange(InertiaMatrix inertia) {
        ValidationStrategy limitValidator = this.momentOfInertiaValidationFactory.getInertiaLimitValidator();
        double[] components = inertia.getComponents(MomentOfInertia.Unit.KG_M2);
        try {
            double[] dArray = components;
            int n = components.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                double component = dArray[n2];
                String value = String.valueOf(component);
                if (!limitValidator.isValid(value)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getInertiaOutOfRangeExceptionMessage(InertiaMatrix inertia) {
        return "Inertia is out of range.";
    }

    public String getInertiaCompositionExceptionMessage() {
        return "Inertia matrix is not valid with current Mass and Center Of Gravity";
    }

    public boolean isTransitionTimeOutOfRange(Time transitionTime) {
        double transitionTimeValue = transitionTime.getAs(Time.Unit.S);
        return transitionTimeValue < 0.0 || transitionTimeValue > 100.0;
    }

    public String getTransitionTimeOutOfRangeExceptionMessage() {
        return String.format(Locale.ENGLISH, "Transition time is out of range. Valid range is between %.2f and %.2f", 0.0, 100.0);
    }

    public Double getTransitionTimeMaxValue() {
        return 100.0;
    }

    public Double getTransitionTimeMinValue() {
        return 0.0;
    }
}

