/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.vecmath.Matrix3d;

public final class SphereOfWaterInertia {
    private static final double DENSITY = 1000.0;

    private SphereOfWaterInertia() {
    }

    private static double calculateMomentInertia(double mass) {
        double radius = SphereOfWaterInertia.calculateRadius(mass);
        return 0.4 * mass * Math.pow(radius, 2.0);
    }

    private static double calculateRadius(double mass) {
        return Math.cbrt(3.0 * mass / 12566.370614359172);
    }

    public static Matrix3d getInertiaMatrix(double mass) {
        if (mass < 0.0) {
            throw new IllegalArgumentException("Mass below zero");
        }
        BigDecimal inertiaBigDecimal = BigDecimal.valueOf(SphereOfWaterInertia.calculateMomentInertia(mass));
        inertiaBigDecimal = inertiaBigDecimal.setScale(6, RoundingMode.HALF_UP);
        double momentInertia = inertiaBigDecimal.doubleValue();
        return new Matrix3d(momentInertia, 0.0, 0.0, 0.0, momentInertia, 0.0, 0.0, 0.0, momentInertia);
    }
}

