/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.domain;

import com.ur.polyscope.payload.InputViewConfigurator;
import com.ur.polyscope.payload.impl.common.domain.MaxValueDoubleValidator;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.InputView;
import com.ur.swing.number.Mode;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import javax.inject.Inject;

public class TransitionTimeInputConfigurator
implements InputViewConfigurator {
    static final double TRANSITION_TIME_MAX_VALUE = 100.0;
    static final double TRANSITION_TIME_MIN_VALUE = 0.0;
    private final TextResource textResource;

    @Inject
    public TransitionTimeInputConfigurator(TextResource textResource) {
        this.textResource = textResource;
    }

    public void configure(InputView entryField) {
        MaxValueDoubleValidator maxValueDoubleValidator = new MaxValueDoubleValidator(100.0, this.textResource);
        ValidationStrategy.Composite errorValidationStrategy = new ValidationStrategy.Composite(new ValidationStrategy[]{maxValueDoubleValidator});
        entryField.setErrorValidationStrategy(new ValidationStrategy[]{errorValidationStrategy});
        ValidationStrategy.Composite warningValidationStrategy = new ValidationStrategy.Composite(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)2)});
        entryField.setWarningValidationStrategy(new ValidationStrategy[]{warningValidationStrategy});
        entryField.setFormat(UnitsValueConverterFactory.getTimeConverter((boolean)true).getFormat());
        entryField.setMode(Mode.PositiveNumbers);
    }
}

