/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.internal;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.common.PayloadSelection;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.payload.impl.urcapapi.PayloadImpl;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.renderers.contributed.ContributedHeading;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.util.swing.TwoIcons;
import javax.inject.Inject;
import javax.swing.Icon;

public class InstallationPayloadRenderer
implements RenderingStrategy {
    private final TextResource textResource;
    private final PayloadService payloadService;

    @Inject
    public InstallationPayloadRenderer(PayloadService payloadService, TextResource textResource) {
        this.payloadService = payloadService;
        this.textResource = textResource;
    }

    public String getText(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof InstallationPayloadComponent) {
            return ((InstallationPayloadComponent)o).getName();
        }
        if (o instanceof PayloadComponent) {
            return this.textResource.customPayload();
        }
        if (o instanceof PayloadReferenceComponent) {
            return ((PayloadReferenceComponent)o).getKey();
        }
        if (o instanceof PayloadSelection) {
            PayloadSelection selection = (PayloadSelection)o;
            PayloadSelection.SelectionType type = selection.getPayloadSelectionType();
            switch (type) {
                case CUSTOM_MASS: {
                    return this.textResource.customPayload();
                }
                case USE_ACTIVE_PAYLOAD: {
                    return this.textResource.activePayload();
                }
            }
            return this.textResource.SelectPayload();
        }
        if (o instanceof Payload) {
            return ((Payload)o).getDisplayName();
        }
        if (o instanceof ContributedHeading) {
            return ((ContributedHeading)o).getDisplayName();
        }
        return o.toString();
    }

    public Icon getIcon(Object o) {
        if (o instanceof PayloadImpl) {
            o = ((PayloadImpl)o).getDereference();
        }
        if (o instanceof PayloadComponent) {
            InstallationPayloadComponent defaultPayload = this.payloadService.getInstallationDefaultPayload();
            PayloadComponent activePayload = this.payloadService.getActivePayload();
            Icon iconSelected = null;
            Icon iconActive = null;
            if (EqualsUtil.equals((Object)defaultPayload, (Object)o)) {
                iconSelected = ImageResource.defaultIconSelected();
            }
            if (EqualsUtil.equals((Object)activePayload, (Object)o)) {
                iconActive = ImageResource.setactive();
            }
            if (iconSelected != null && iconActive != null) {
                int width = iconSelected.getIconWidth() + 2 + iconActive.getIconWidth();
                return new TwoIcons(iconSelected, iconActive, width, 20);
            }
            if (iconSelected != null) {
                return iconSelected;
            }
            if (iconActive != null) {
                return iconActive;
            }
        } else if (o instanceof PayloadReferenceComponent) {
            return this.getIcon(this.payloadService.getPayloadByName(((PayloadReferenceComponent)o).getKey()));
        }
        return null;
    }

    public boolean hasError(Object o) {
        PayloadComponent payloadComponent;
        if (o instanceof Payload) {
            Payload payload = (Payload)o;
            if (!payload.isResolvable()) {
                return true;
            }
            if (payload instanceof PayloadImpl) {
                o = ((PayloadImpl)payload).getDereference();
            } else {
                return false;
            }
        }
        if (o instanceof InstallationPayloadComponent) {
            payloadComponent = (PayloadComponent)o;
            return !payloadComponent.isDefined() || !InertiaDecomposition.isValid(payloadComponent);
        }
        if (o instanceof PayloadReferenceComponent) {
            payloadComponent = this.payloadService.getPayloadByName(((PayloadReferenceComponent)o).getKey());
            return payloadComponent == null || !payloadComponent.isDefined() || !InertiaDecomposition.isValid(payloadComponent);
        }
        return false;
    }
}

