/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.internal;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.swing.renderers.contributed.ContributedComboBoxModel;
import com.ur.swing.renderers.contributed.ContributedHeading;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;

public class PayloadComboBoxContentHandler {
    private final TextResource textResource;

    public PayloadComboBoxContentHandler(TextResource textResource) {
        this.textResource = textResource;
    }

    public DefaultComboBoxModel getPayloadComboBoxModel(Collection<? extends DomainComponent> payloads) {
        ContributedComboBoxModel model = new ContributedComboBoxModel();
        this.setUserDefinedPayloadComboBoxModel((DefaultComboBoxModel)model, payloads);
        this.setURCapPayloadComboBoxModel((DefaultComboBoxModel)model, payloads);
        this.setUndefinedPayloadsComboBoxModel((DefaultComboBoxModel)model, payloads);
        return model;
    }

    private void setUndefinedPayloadsComboBoxModel(DefaultComboBoxModel model, Collection<? extends DomainComponent> payloads) {
        List<DomainComponent> undefinedPayloads = this.getUndefinedPayloads(payloads);
        if (undefinedPayloads.size() == 0) {
            return;
        }
        ContributedHeading heading = new ContributedHeading(this.textResource.undefinedPayload());
        model.addElement(heading);
        for (DomainComponent each : undefinedPayloads) {
            model.addElement(each);
        }
    }

    private Map<ContributedHeading, List<DomainComponent>> getURCapPayloadVendorMap(Collection<? extends DomainComponent> allPayloads) {
        TreeMap<ContributedHeading, List<DomainComponent>> urCapPayloadVendorMap = new TreeMap<ContributedHeading, List<DomainComponent>>();
        List<DomainComponent> contributedPayloads = this.getContributedPayloads(allPayloads);
        for (DomainComponent payloadContributed : contributedPayloads) {
            if (payloadContributed == null) continue;
            String ownerDisplayName = payloadContributed instanceof PayloadReferenceComponent ? ((PayloadReferenceComponent)payloadContributed).dereference().getContributorInfo().getOwnerDisplayName() : ((InstallationPayloadComponent)payloadContributed).getContributorInfo().getOwnerDisplayName();
            ContributedHeading urCapHeading = new ContributedHeading(ownerDisplayName);
            ArrayList<DomainComponent> payloads = (ArrayList<DomainComponent>)urCapPayloadVendorMap.get(urCapHeading);
            if (payloads == null) {
                payloads = new ArrayList<DomainComponent>();
            }
            payloads.add(payloadContributed);
            urCapPayloadVendorMap.put(urCapHeading, payloads);
        }
        return urCapPayloadVendorMap;
    }

    private void setURCapPayloadComboBoxModel(DefaultComboBoxModel model, Collection<? extends DomainComponent> payloads) {
        Map<ContributedHeading, List<DomainComponent>> urCapPayloadVendorMap = this.getURCapPayloadVendorMap(payloads);
        for (Map.Entry<ContributedHeading, List<DomainComponent>> entry : urCapPayloadVendorMap.entrySet()) {
            model.addElement(entry.getKey());
            for (DomainComponent payloadContributed : entry.getValue()) {
                model.addElement(payloadContributed);
            }
        }
    }

    private void setUserDefinedPayloadComboBoxModel(DefaultComboBoxModel model, Collection<? extends DomainComponent> payloads) {
        List<DomainComponent> userDefinedPayloads = this.getUserDefinedPayloads(payloads);
        for (DomainComponent payload : userDefinedPayloads) {
            model.addElement(payload);
        }
    }

    public List<Object> getURCapPayloadComboBoxContent(Collection<? extends DomainComponent> payloads) {
        ArrayList<Object> contributedPayloads = new ArrayList<Object>();
        Map<ContributedHeading, List<DomainComponent>> urCapPayloadVendorMap = this.getURCapPayloadVendorMap(payloads);
        for (Map.Entry<ContributedHeading, List<DomainComponent>> entry : urCapPayloadVendorMap.entrySet()) {
            contributedPayloads.add(entry.getKey());
            for (DomainComponent payloadContributed : entry.getValue()) {
                contributedPayloads.add(payloadContributed);
            }
        }
        return contributedPayloads;
    }

    private List<DomainComponent> getContributedPayloads(Collection<? extends DomainComponent> allPayloads) {
        LinkedList<DomainComponent> payloads = new LinkedList<DomainComponent>(allPayloads);
        Iterator iterator = payloads.iterator();
        while (iterator.hasNext()) {
            DomainComponent payload = (DomainComponent)iterator.next();
            if (payload.isDefined() && !this.isUserDefined(payload)) continue;
            iterator.remove();
        }
        return payloads;
    }

    public List<DomainComponent> getUserDefinedPayloads(Collection<? extends DomainComponent> allPayloads) {
        LinkedList<DomainComponent> payloads = new LinkedList<DomainComponent>(allPayloads);
        Iterator iterator = payloads.iterator();
        while (iterator.hasNext()) {
            DomainComponent payload = (DomainComponent)iterator.next();
            if (payload.isDefined() && this.isUserDefined(payload)) continue;
            iterator.remove();
        }
        return payloads;
    }

    private List<DomainComponent> getUndefinedPayloads(Collection<? extends DomainComponent> allPayloads) {
        LinkedList<DomainComponent> payloads = new LinkedList<DomainComponent>(allPayloads);
        Iterator iterator = payloads.iterator();
        while (iterator.hasNext()) {
            DomainComponent payload = (DomainComponent)iterator.next();
            if (!payload.isDefined()) continue;
            iterator.remove();
        }
        return payloads;
    }

    private boolean isUserDefined(DomainComponent payload) {
        if (payload instanceof PayloadReferenceComponent) {
            return ((PayloadReferenceComponent)payload).dereference().isUserDefined();
        }
        return ((PayloadComponent)payload).isUserDefined();
    }
}

