/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.internal;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComboBoxContentProvider;
import com.ur.polyscope.payload.impl.common.internal.PayloadComboBoxContentHandler;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.payload.urcap.PayloadFactory;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PayloadComboBoxContentProviderImpl
implements PayloadComboBoxContentProvider {
    private final PayloadComboBoxContentHandler payloadComboBoxContentHandler;
    private final InstallationComponentLookup lookup;
    private final PayloadFactory payloadFactory;

    @Inject
    public PayloadComboBoxContentProviderImpl(InstallationComponentLookup lookup, PayloadFactory payloadFactory, TextResource textResource) {
        this.lookup = lookup;
        this.payloadFactory = payloadFactory;
        this.payloadComboBoxContentHandler = new PayloadComboBoxContentHandler(textResource);
    }

    public List<Object> getContributedPayloads() {
        PayloadSettings settings = (PayloadSettings)this.lookup.getComponent(PayloadSettings.class);
        ArrayList<Object> content = new ArrayList<Object>();
        for (Object entry : this.payloadComboBoxContentHandler.getURCapPayloadComboBoxContent(settings.getAllPayloads())) {
            if (entry instanceof InstallationPayloadComponent) {
                content.add(this.payloadFactory.createPayloadWrapper((InstallationPayloadComponent)entry));
                continue;
            }
            content.add(entry);
        }
        return content;
    }

    public List<Object> getUserDefinedPayloads() {
        PayloadSettings settings = (PayloadSettings)this.lookup.getComponent(PayloadSettings.class);
        ArrayList<Object> content = new ArrayList<Object>();
        for (DomainComponent entry : this.payloadComboBoxContentHandler.getUserDefinedPayloads(settings.getAllPayloads())) {
            content.add(this.payloadFactory.createPayloadWrapper((InstallationPayloadComponent)entry));
        }
        return content;
    }
}

