/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.internal;

import com.ur.polyscope.payload.impl.common.domain.MassInputConfigurator;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.InputView;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.swing.number.NumberField;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JComponent;

public class WeightInputFactory {
    private static final String HELP_ID_MASS = "gui:installation:payload";
    private final WidgetFactory widgetFactory;
    private final MassInputConfigurator payloadInputViewConfigurator;
    private final HelpIdAssignerExt helpIdAssigner;

    @Inject
    public WeightInputFactory(ViewContext viewContext, MassInputConfigurator weightInputViewConfigurator) {
        this.payloadInputViewConfigurator = weightInputViewConfigurator;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
    }

    public NumberField getEntryField(ActionListener actionListener) {
        NumberField weightField = this.widgetFactory.createNumberField(actionListener, UnitsValueConverterFactory.getWeightConverter(), false);
        this.payloadInputViewConfigurator.configure((InputView)weightField);
        weightField.setPreferredSize(new Dimension(80, 28));
        weightField.setUnitWidth(35);
        weightField.setName(com.ur.polyscope.application.driver.payload.names.WeightInputFactory.WEIGHT_FIELD_NAME);
        this.helpIdAssigner.assignHelpId((JComponent)weightField, HELP_ID_MASS);
        return weightField;
    }
}

