/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.view;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.internal.InstallationPayloadRenderer;
import com.ur.polyscope.payload.impl.common.internal.PayloadComboBoxContentHandler;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.WidgetFactory;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import com.ur.util.logging.Log;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuListener;

public abstract class AbstractPayloadSelectionView
implements ViewComponent {
    protected final PayloadService payloadService;
    protected final TextResource textResource;
    protected final PayloadComboBoxContentHandler payloadComboBoxContentHandler;
    protected JComboBox payloadListComboBox;
    protected PayloadComponent payloadComponent;
    private ViewComponent.ModifyListener modifyListener;
    private ActionListener comboBoxActionListener = new ComboBoxActionListener();

    protected AbstractPayloadSelectionView(PayloadService payloadService, ViewContext viewContext) {
        this.payloadService = payloadService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.payloadComboBoxContentHandler = new PayloadComboBoxContentHandler((TextResource)viewContext.getTextResource(TextResource.class));
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        InstallationPayloadRenderer installationPayloadRenderer = new InstallationPayloadRenderer(payloadService, this.textResource);
        this.payloadListComboBox = widgetFactory.createComboBox();
        this.payloadListComboBox.setName(this.getComboBoxName());
        this.payloadListComboBox.setPreferredSize(new Dimension(80, 32));
        this.payloadListComboBox.setRenderer(new ContributedComboBoxRenderer((RenderingStrategy)installationPayloadRenderer));
        this.payloadListComboBox.setModel(this.getComboBoxModel());
        this.payloadListComboBox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer((RenderingStrategy)installationPayloadRenderer, 500));
        this.addActionListeners();
    }

    protected abstract ComboBoxModel getComboBoxModel();

    protected abstract DomainComponent getSelectedItem();

    protected abstract String getComboBoxName();

    protected abstract void performSetDomain(DomainComponent var1);

    public final void setDomain(DomainComponent domainComponent) {
        this.removeActionListeners();
        this.performSetDomain(domainComponent);
        this.addActionListeners();
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public JComponent asComponent() {
        return this.payloadListComboBox;
    }

    private void addActionListeners() {
        this.payloadListComboBox.addActionListener(this.comboBoxActionListener);
    }

    private void removeActionListeners() {
        this.payloadListComboBox.removeActionListener(this.comboBoxActionListener);
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractPayloadSelectionView.this.modifyListener != null) {
                AbstractPayloadSelectionView.this.modifyListener.onModified(AbstractPayloadSelectionView.this.getSelectedItem());
            } else {
                Log.warning((String)"No listener when value has changed");
            }
        }
    }
}

