/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.view;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.impl.common.domain.SphereOfWaterInertia;
import com.ur.polyscope.payload.impl.common.internal.CogInputFactory;
import com.ur.polyscope.payload.impl.common.internal.WeightInputFactory;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningProvider;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

@HasKey(value="payload-mass-cog")
public class PayloadDetailsView
implements ViewComponent {
    private NumberField weightField;
    private NumberField[] cogFields;
    private JComponent content;
    private PayloadComponent payloadComponent;
    private ViewComponent.ModifyListener modifyListener;
    private final PayloadAndCogWarningCalculator payloadAndCogWarning;

    @Inject
    public PayloadDetailsView(ViewContext viewContext, WeightInputFactory weightInputFactory, CogInputFactory cogInputFactory, PayloadAndCogWarningProvider payloadAndCogWarningProvider) {
        this.payloadAndCogWarning = payloadAndCogWarningProvider.getPayloadAndCogWarning();
        this.initComponents(viewContext, weightInputFactory, cogInputFactory);
    }

    private void initComponents(ViewContext viewContext, WeightInputFactory weightInputFactory, CogInputFactory cogInputFactory) {
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        PayloadUpdater listener = new PayloadUpdater();
        this.weightField = weightInputFactory.getEntryField(listener);
        this.cogFields = cogInputFactory.getEntryFields(listener);
        JLabel headerLabel = new JLabel(HTML.html((String)HTML.fontBold((String)textResource.payload())));
        JLabel centerOfGravity = new JLabel(HTML.html((String)HTML.fontBold((String)textResource.payloadCogSection())));
        this.content = viewContext.createFormBuilder().component((JComponent)headerLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label(textResource.payloadMass(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.weightField, new FormBuilder.PanelConstraints[0]).end().component((JComponent)centerOfGravity, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().componentWithLabel("CX", (JComponent)this.cogFields[0], new FormBuilder.PanelConstraints[0]).end().componentWithLabel("CY", (JComponent)this.cogFields[1], new FormBuilder.PanelConstraints[0]).end().componentWithLabel("CZ", (JComponent)this.cogFields[2], new FormBuilder.PanelConstraints[0]).getPanel();
        this.content.setBorder(BorderFactory.createEmptyBorder(0, -5, 0, 0));
        this.addPayloadAndCogWarningStrategies();
    }

    public JComponent asComponent() {
        return this.content;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setReadOnly(boolean readOnly) {
        this.weightField.setEnabled(!readOnly);
        NumberField[] numberFieldArray = this.cogFields;
        int n = this.cogFields.length;
        int n2 = 0;
        while (n2 < n) {
            NumberField cogTextField = numberFieldArray[n2];
            cogTextField.setEnabled(!readOnly);
            ++n2;
        }
    }

    public void setDomain(DomainComponent domainComponent) {
        if (domainComponent == null) {
            return;
        }
        if (domainComponent instanceof PayloadReferenceComponent) {
            this.payloadComponent = domainComponent.isDefined() ? ((PayloadReferenceComponent)domainComponent).dereference() : PayloadComponent.ZERO_PAYLOAD;
        } else {
            this.payloadComponent = (PayloadComponent)domainComponent;
            this.setFieldsEnabled(this.payloadComponent.isUserDefined());
        }
        this.weightField.setValue((Object)this.payloadComponent.getMass());
        Vector3d cog = this.payloadComponent.getCenterOfGravity();
        this.cogFields[0].setValue((Object)Length.from((double)cog.x, (Length.Unit)Length.Unit.M));
        this.cogFields[1].setValue((Object)Length.from((double)cog.y, (Length.Unit)Length.Unit.M));
        this.cogFields[2].setValue((Object)Length.from((double)cog.z, (Length.Unit)Length.Unit.M));
    }

    private void setFieldsEnabled(boolean enabled) {
        this.weightField.setEnabled(enabled);
        this.cogFields[0].setEnabled(enabled);
        this.cogFields[1].setEnabled(enabled);
        this.cogFields[2].setEnabled(enabled);
    }

    public NumberField getPayloadMass() {
        return this.weightField;
    }

    public NumberField[] getCoGFields() {
        return this.cogFields;
    }

    private void addPayloadAndCogWarningStrategies() {
        PayloadAndCogWarningStrategy payloadAndCogStrategy = new PayloadAndCogWarningStrategy();
        NumberField[] numberFieldArray = this.cogFields;
        int n = this.cogFields.length;
        int n2 = 0;
        while (n2 < n) {
            NumberField cogField = numberFieldArray[n2];
            ValidationStrategy.Composite combined = new ValidationStrategy.Composite(new ValidationStrategy[]{cogField.getWarningValidationStrategy(), payloadAndCogStrategy});
            cogField.setWarningValidationStrategy(new ValidationStrategy[]{combined});
            ++n2;
        }
        ValidationStrategy.Composite combined = new ValidationStrategy.Composite(new ValidationStrategy[]{this.weightField.getWarningValidationStrategy(), payloadAndCogStrategy});
        this.weightField.setWarningValidationStrategy(new ValidationStrategy[]{combined});
    }

    private class PayloadAndCogWarningStrategy
    implements ValidationStrategy {
        private PayloadAndCogWarningStrategy() {
        }

        public boolean isValid(String s) {
            return PayloadDetailsView.this.payloadAndCogWarning.isPayloadAndCogValid(PayloadDetailsView.this.payloadComponent.getMass(), Length.from((double)PayloadDetailsView.this.payloadComponent.getCenterOfGravity().length(), (Length.Unit)Length.Unit.M));
        }

        public String getErrorMessage(String s) {
            return null;
        }
    }

    private class PayloadUpdater
    implements ActionListener {
        private PayloadUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Weight weight = (Weight)PayloadDetailsView.this.weightField.getValue();
            Vector3d cog = new Vector3d(((NumberValue)PayloadDetailsView.this.cogFields[0].getValue()).asDouble(), ((NumberValue)PayloadDetailsView.this.cogFields[1].getValue()).asDouble(), ((NumberValue)PayloadDetailsView.this.cogFields[2].getValue()).asDouble());
            Matrix3d inertiaMatrix = SphereOfWaterInertia.getInertiaMatrix(weight.asDouble());
            boolean customInertia = PayloadDetailsView.this.payloadComponent.isCustomInertiaEnabled();
            if (customInertia) {
                inertiaMatrix = PayloadDetailsView.this.payloadComponent.getInertiaMatrix();
            }
            PayloadComponent oldPayloadComponent = PayloadDetailsView.this.payloadComponent;
            PayloadComponent payload = new PayloadComponent(weight, cog, inertiaMatrix);
            PayloadDetailsView.this.payloadComponent = new PayloadComponent(payload, customInertia);
            this.triggerOnModifiedIfPayloadHasChanged(oldPayloadComponent);
        }

        private void triggerOnModifiedIfPayloadHasChanged(PayloadComponent oldPayloadComponent) {
            if (!PayloadDetailsView.this.payloadComponent.equals((Object)oldPayloadComponent) && PayloadDetailsView.this.modifyListener != null) {
                PayloadDetailsView.this.modifyListener.onModified((DomainComponent)PayloadDetailsView.this.payloadComponent);
            }
        }
    }
}

