/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.view;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.payload.impl.common.domain.SphereOfWaterInertia;
import com.ur.polyscope.payload.impl.common.internal.MomentOfInertiaInputFactory;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.MomentOfInertia;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.ArrayUtils;
import com.ur.util.swing.HTML;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Matrix3d;

@HasKey(value="payload-inertia")
public class PayloadInertiaView
implements ViewComponent {
    protected NumberField[] inertiaMatrixFields;
    private NumberField[] duplicatedInertiaFields;
    private final MomentOfInertiaInputFactory momentOfInertiaInputFactory;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final TextResource textResource;
    private JLabel xColumnLabel;
    private JLabel yColumnLabel;
    private JLabel zColumnLabel;
    private JLabel xRowLabel;
    private JLabel yRowLabel;
    private JLabel zRowLabel;
    private JCheckBox inertiaCheckbox;
    private final ViewContext viewContext;
    private JPanel content;
    private InstallationPayloadComponent payloadComponent;
    private ViewComponent.ModifyListener modifyListener;

    @Inject
    public PayloadInertiaView(ViewContext viewContext, MomentOfInertiaInputFactory momentOfInertiaInputFactory, ConfirmationDialogCreator confirmationDialogCreator) {
        this.viewContext = viewContext;
        this.momentOfInertiaInputFactory = momentOfInertiaInputFactory;
        this.confirmationDialogCreator = confirmationDialogCreator;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.initComponents();
        this.assignHelpIDs();
        this.updateStateOfInertiaFields();
    }

    private void initComponents() {
        PayloadUpdater listener = new PayloadUpdater();
        this.inertiaCheckbox = new JCheckBox(this.textResource.payloadInertiaMatrixSection());
        this.inertiaCheckbox.setName(com.ur.polyscope.application.driver.payload.names.PayloadInertiaView.USE_CUSTOM_INERTIA_NAME);
        this.inertiaCheckbox.addActionListener(listener);
        this.inertiaMatrixFields = this.momentOfInertiaInputFactory.getEntryFields(listener);
        this.duplicatedInertiaFields = this.momentOfInertiaInputFactory.getDuplicatedFields();
        this.duplicatedInertiaFields[0].setEnabled(false);
        this.duplicatedInertiaFields[1].setEnabled(false);
        this.duplicatedInertiaFields[2].setEnabled(false);
        this.xColumnLabel = new JLabel("X", 0);
        this.yColumnLabel = new JLabel("Y", 0);
        this.zColumnLabel = new JLabel("Z", 0);
        this.xRowLabel = new JLabel("X", 0);
        this.xRowLabel.setMinimumSize(new Dimension(60, 1));
        this.xRowLabel.setPreferredSize(new Dimension(60, 1));
        this.xRowLabel.setMaximumSize(new Dimension(60, 19));
        this.yRowLabel = new JLabel("Y", 0);
        this.zRowLabel = new JLabel("Z", 0);
        this.content = this.viewContext.createFormBuilder().label(HTML.fontBold((String)(String.valueOf(this.textResource.inertia()) + " (" + this.momentOfInertiaInputFactory.getInertiaUnitText() + ")")), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)this.inertiaCheckbox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().spacer(1).component((JComponent)this.xColumnLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.yColumnLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.zColumnLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.xRowLabel, new FormBuilder.PanelConstraints[0]).component((JComponent)this.inertiaMatrixFields[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.inertiaMatrixFields[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.inertiaMatrixFields[4], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.yRowLabel, new FormBuilder.PanelConstraints[0]).component((JComponent)this.duplicatedInertiaFields[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.inertiaMatrixFields[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.inertiaMatrixFields[5], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.zRowLabel, new FormBuilder.PanelConstraints[0]).component((JComponent)this.duplicatedInertiaFields[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.duplicatedInertiaFields[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.inertiaMatrixFields[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).getPanel();
        this.addInertiaStrategies();
    }

    private void assignHelpIDs() {
        HelpIdAssignerExt helpIdAssigner = this.viewContext.getHelpIdAssigner();
        helpIdAssigner.assignHelpId((JComponent)this.inertiaCheckbox, "gui:payload_inertia");
    }

    private void triggerOnModifiedIfPayloadHasChanged(PayloadComponent oldPayloadComponent) {
        if (!this.payloadComponent.equals((Object)oldPayloadComponent) && this.modifyListener != null) {
            this.modifyListener.onModified((DomainComponent)this.payloadComponent);
        }
    }

    private void showClearValuesDialog(final PayloadComponent oldPayloadComponent) {
        this.confirmationDialogCreator.showConfirmationDialog(new ConfirmationMessage(this.textResource.confirmRemoveInertiaTitle(), this.textResource.confirmRemoveInertiaDescription(), this.textResource.yes(), this.textResource.cancel()), new ConfirmationDialogListener(){

            public void onOkClicked() {
                PayloadInertiaView.this.payloadComponent = new InstallationPayloadComponent(PayloadInertiaView.this.payloadComponent.getName(), new PayloadComponent(PayloadInertiaView.this.payloadComponent.getMass(), PayloadInertiaView.this.payloadComponent.getCenterOfGravity(), SphereOfWaterInertia.getInertiaMatrix(PayloadInertiaView.this.payloadComponent.getMass().asDouble())), PayloadInertiaView.this.payloadComponent.getContributorInfo(), false);
                PayloadInertiaView.this.updateStateOfInertiaFields();
                PayloadInertiaView.this.triggerOnModifiedIfPayloadHasChanged(oldPayloadComponent);
            }

            public void onCancelClicked() {
                PayloadInertiaView.this.inertiaCheckbox.setSelected(true);
            }
        });
    }

    private void updateStateOfInertiaFields() {
        boolean isPayloadEditable = this.payloadComponent == null || this.payloadComponent.isUserDefined();
        boolean enableInertiaFields = isPayloadEditable && this.inertiaCheckbox.isSelected();
        NumberField[] numberFieldArray = this.inertiaMatrixFields;
        int n = this.inertiaMatrixFields.length;
        int n2 = 0;
        while (n2 < n) {
            NumberField inertiaField = numberFieldArray[n2];
            inertiaField.setEnabled(enableInertiaFields);
            ++n2;
        }
        this.xColumnLabel.setEnabled(enableInertiaFields);
        this.yColumnLabel.setEnabled(enableInertiaFields);
        this.zColumnLabel.setEnabled(enableInertiaFields);
        this.xRowLabel.setEnabled(enableInertiaFields);
        this.yRowLabel.setEnabled(enableInertiaFields);
        this.zRowLabel.setEnabled(enableInertiaFields);
        this.inertiaCheckbox.setEnabled(isPayloadEditable);
    }

    public JComponent asComponent() {
        return this.content;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setDomain(DomainComponent domainComponent) {
        if (domainComponent == null) {
            domainComponent = new InstallationPayloadComponent(PayloadComponent.ZERO_PAYLOAD);
        }
        this.payloadComponent = (InstallationPayloadComponent)domainComponent;
        Matrix3d inertia = this.payloadComponent.getInertiaMatrix();
        this.inertiaMatrixFields[0].setValue((Object)MomentOfInertia.create((double)inertia.m00, (MomentOfInertia.Unit)MomentOfInertia.Unit.KG_M2));
        this.inertiaMatrixFields[1].setValue((Object)MomentOfInertia.create((double)inertia.m11, (MomentOfInertia.Unit)MomentOfInertia.Unit.KG_M2));
        this.inertiaMatrixFields[2].setValue((Object)MomentOfInertia.create((double)inertia.m22, (MomentOfInertia.Unit)MomentOfInertia.Unit.KG_M2));
        this.inertiaMatrixFields[3].setValue((Object)MomentOfInertia.create((double)inertia.m01, (MomentOfInertia.Unit)MomentOfInertia.Unit.KG_M2));
        this.inertiaMatrixFields[4].setValue((Object)MomentOfInertia.create((double)inertia.m02, (MomentOfInertia.Unit)MomentOfInertia.Unit.KG_M2));
        this.inertiaMatrixFields[5].setValue((Object)MomentOfInertia.create((double)inertia.m12, (MomentOfInertia.Unit)MomentOfInertia.Unit.KG_M2));
        this.duplicatedInertiaFields[0].setValue(this.inertiaMatrixFields[3].getValue());
        this.duplicatedInertiaFields[1].setValue(this.inertiaMatrixFields[4].getValue());
        this.duplicatedInertiaFields[2].setValue(this.inertiaMatrixFields[5].getValue());
        this.inertiaCheckbox.setSelected(this.payloadComponent.isCustomInertiaEnabled());
        this.updateStateOfInertiaFields();
    }

    private void addInertiaStrategies() {
        ValidationStrategy.Composite combinedStrategy;
        NumberField field;
        InertiaWarningStrategy inertiaWarningStrategy = new InertiaWarningStrategy();
        NumberField[] numberFieldArray = this.inertiaMatrixFields;
        int n = this.inertiaMatrixFields.length;
        int n2 = 0;
        while (n2 < n) {
            field = numberFieldArray[n2];
            combinedStrategy = new ValidationStrategy.Composite(new ValidationStrategy[]{field.getWarningValidationStrategy(), inertiaWarningStrategy});
            field.setWarningValidationStrategy(new ValidationStrategy[]{combinedStrategy});
            ++n2;
        }
        numberFieldArray = this.duplicatedInertiaFields;
        n = this.duplicatedInertiaFields.length;
        n2 = 0;
        while (n2 < n) {
            field = numberFieldArray[n2];
            combinedStrategy = new ValidationStrategy.Composite(new ValidationStrategy[]{field.getWarningValidationStrategy(), inertiaWarningStrategy});
            field.setWarningValidationStrategy(new ValidationStrategy[]{combinedStrategy});
            ++n2;
        }
    }

    private class InertiaWarningStrategy
    implements ValidationStrategy {
        private InertiaWarningStrategy() {
        }

        public boolean isValid(String s) {
            return InertiaDecomposition.isValid((PayloadComponent)PayloadInertiaView.this.payloadComponent);
        }

        public String getErrorMessage(String s) {
            return null;
        }
    }

    private class PayloadUpdater
    implements ActionListener {
        private PayloadUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstallationPayloadComponent oldPayloadComponent = PayloadInertiaView.this.payloadComponent;
            if (ArrayUtils.contains((Object)actionEvent.getSource(), (Object[])PayloadInertiaView.this.inertiaMatrixFields)) {
                PayloadInertiaView.this.duplicatedInertiaFields[0].setValue(PayloadInertiaView.this.inertiaMatrixFields[3].getValue());
                PayloadInertiaView.this.duplicatedInertiaFields[1].setValue(PayloadInertiaView.this.inertiaMatrixFields[4].getValue());
                PayloadInertiaView.this.duplicatedInertiaFields[2].setValue(PayloadInertiaView.this.inertiaMatrixFields[5].getValue());
                int len = PayloadInertiaView.this.inertiaMatrixFields.length;
                double[] iValue = new double[len];
                int i = 0;
                while (i < len) {
                    iValue[i] = ((NumberValue)PayloadInertiaView.this.inertiaMatrixFields[i].getValue()).asDouble();
                    ++i;
                }
                Matrix3d updatedInertia = new Matrix3d(iValue[0], iValue[3], iValue[4], iValue[3], iValue[1], iValue[5], iValue[4], iValue[5], iValue[2]);
                PayloadInertiaView.this.payloadComponent = new InstallationPayloadComponent(PayloadInertiaView.this.payloadComponent.getName(), new PayloadComponent(PayloadInertiaView.this.payloadComponent.getMass(), PayloadInertiaView.this.payloadComponent.getCenterOfGravity(), updatedInertia), PayloadInertiaView.this.payloadComponent.getContributorInfo(), true);
            } else if (actionEvent.getSource() == PayloadInertiaView.this.inertiaCheckbox) {
                if (PayloadInertiaView.this.inertiaCheckbox.isSelected()) {
                    PayloadInertiaView.this.payloadComponent = new InstallationPayloadComponent(PayloadInertiaView.this.payloadComponent.getName(), new PayloadComponent(PayloadInertiaView.this.payloadComponent.getMass(), PayloadInertiaView.this.payloadComponent.getCenterOfGravity(), PayloadInertiaView.this.payloadComponent.getInertiaMatrix()), PayloadInertiaView.this.payloadComponent.getContributorInfo(), true);
                    PayloadInertiaView.this.updateStateOfInertiaFields();
                } else {
                    PayloadInertiaView.this.showClearValuesDialog((PayloadComponent)oldPayloadComponent);
                }
            }
            PayloadInertiaView.this.triggerOnModifiedIfPayloadHasChanged((PayloadComponent)oldPayloadComponent);
        }
    }
}

