/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.view;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.robotstate.model.PayloadAttributesModel;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.swing.ViewContext;
import com.ur.swing.card.EnterExitCard;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.FooterExtension;
import com.ur.swing.g5.CardBorder;
import com.ur.util.event.Subscription;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

@Extension(value="InitializeRobot")
public class PayloadPanel
extends JPanel
implements FooterExtension,
EnterExitCard {
    private final InstallationComponentLookup installationComponentLookup;
    private final ViewComponent activePayloadView;
    private final Recipe<PayloadAttributesModel> payloadRecipe;
    private Subscription activePayloadSubscription;

    @Inject
    public PayloadPanel(@Named(value="payload-initialization") @Named(value="payload-initialization") ViewComponent activePayloadView, ViewContext context, InstallationComponentLookup lookup, @Source(value=PayloadAttributesModel.class) Recipe<PayloadAttributesModel> payloadRecipe) {
        this.activePayloadView = activePayloadView;
        this.installationComponentLookup = lookup;
        this.payloadRecipe = payloadRecipe;
        this.initView(context);
    }

    private void initView(ViewContext context) {
        TextResource textResource = (TextResource)context.getTextResource(TextResource.class);
        this.setBorder((Border)new CardBorder(textResource.payload()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.activePayloadView.asComponent(), "First");
    }

    public void enter(Object o) {
        PayloadSettings payloadSettings = (PayloadSettings)this.installationComponentLookup.getComponent(PayloadSettings.class);
        if (payloadSettings.getActivePayload() != null) {
            this.setDomainOnView(payloadSettings);
        }
        this.activePayloadSubscription = this.payloadRecipe.executeOnUIThread().subscribe(payloadModel -> this.setDomainOnView(payloadSettings));
    }

    public Object exit() {
        this.activePayloadSubscription.dispose();
        this.activePayloadSubscription = null;
        return null;
    }

    public JComponent createFooter() {
        this.putClientProperty("placement", 0);
        return this;
    }

    private void setDomainOnView(PayloadSettings payloadSettings) {
        this.activePayloadView.setDomain((DomainComponent)PayloadComponent.ZERO_PAYLOAD);
        this.activePayloadView.setDomain((DomainComponent)payloadSettings.getActivePayload());
    }
}

