/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.view;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.payload.impl.common.view.AbstractPayloadSelectionView;
import com.ur.swing.ViewContext;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.ComboBoxModel;

public class PayloadSelectionView
extends AbstractPayloadSelectionView {
    @Inject
    public PayloadSelectionView(PayloadService payloadService, ViewContext viewContext) {
        super(payloadService, viewContext);
    }

    @Override
    public void performSetDomain(DomainComponent activePayloadComponent) {
        if (activePayloadComponent instanceof PayloadComponent && activePayloadComponent != this.payloadComponent) {
            this.payloadComponent = (PayloadComponent)activePayloadComponent;
        }
        ComboBoxModel comboBoxModel = this.getComboBoxModel();
        comboBoxModel.setSelectedItem(activePayloadComponent);
        this.payloadListComboBox.setModel(comboBoxModel);
    }

    @Override
    protected ComboBoxModel getComboBoxModel() {
        return this.payloadComboBoxContentHandler.getPayloadComboBoxModel(this.getPayloadComponents());
    }

    @Override
    protected DomainComponent getSelectedItem() {
        return (PayloadComponent)this.payloadListComboBox.getSelectedItem();
    }

    @Override
    protected String getComboBoxName() {
        return com.ur.polyscope.application.driver.payload.names.PayloadSelectionView.COMBO_BOX_NAME;
    }

    private Set<PayloadComponent> getPayloadComponents() {
        LinkedHashSet<PayloadComponent> allNamedPayloads = new LinkedHashSet<PayloadComponent>(this.payloadService.getAllPayloads());
        Iterator iterator = allNamedPayloads.iterator();
        while (iterator.hasNext()) {
            PayloadComponent payloadComponent = (PayloadComponent)iterator.next();
            if (InertiaDecomposition.isValid(payloadComponent)) continue;
            iterator.remove();
        }
        if (this.payloadComponent != null) {
            allNamedPayloads.add(this.payloadComponent);
        }
        return allNamedPayloads;
    }
}

