/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.common.view;

import com.ur.polyscope.payload.TextResource;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import javax.inject.Inject;

public class PayloadValidationStrategy
implements ValidationStrategy {
    private final RobotConfigurationProvider robotConfigurationProvider;
    private final TextResource textResource;
    private final ValueConverter<String, Weight> weightConverter;

    @Inject
    public PayloadValidationStrategy(RobotConfigurationProvider robotConfigurationProvider, TextResource textResource) {
        this.robotConfigurationProvider = robotConfigurationProvider;
        this.textResource = textResource;
        this.weightConverter = UnitsValueConverterFactory.getWeightConverter();
    }

    public boolean isValid(String uncheckedString) {
        Weight mass = (Weight)this.weightConverter.fromGui((Object)uncheckedString);
        Weight limit = Weight.from((double)this.robotConfigurationProvider.getRobotPayload().getMaximumPayload(false).asDouble(), (Weight.Unit)Weight.Unit.SI);
        return mass.getIn(Weight.Unit.SI) <= limit.asDouble();
    }

    public String getErrorMessage(String uncheckedString) {
        Weight maxPayloadSoftLimitSI = Weight.from((double)this.robotConfigurationProvider.getRobotPayload().getMaximumPayload(false).asDouble(), (Weight.Unit)Weight.Unit.SI);
        String maxPayloadConverted = this.weightConverter.getFormat().format(Double.parseDouble((String)this.weightConverter.fromModel((Object)maxPayloadSoftLimitSI)));
        String unit = this.weightConverter.getUnit();
        return HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.ratedpPayloadExceeded(maxPayloadConverted, unit))));
    }
}

