/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.impl.installation.InstallationPayloadMenuExtension;
import com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView;
import com.ur.polyscope.payload.impl.installation.visualization.PayloadVisualizationPanel;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.SwingUtil;
import com.ur.swing.card.ShowIconListener;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.Icon;

@Singleton
public class InstallationPayloadConfigurationTab
extends CardPanel {
    private InstallationPayloadsListView installationPayloadsListView;
    private final InstallationComponentLookup lookup;
    private final PayloadVisualizationPanel payloadVisualizationPanel;
    private final EventManager eventManager;
    private InstallationStateListener refreshOnInstallationLoad = new RefreshOnInstallationLoaded();
    private Subscription refreshOnInstallationLoadSub = Subscription.NULL;
    private final Provider<InstallationPayloadMenuExtension> installationPayloadMenuExtensionProvider;
    private InstallationPayloadMenuExtension installationPayloadMenuExtension;
    private InstallationLoadingContext installationLoadingContext;

    @Inject
    public InstallationPayloadConfigurationTab(InstallationComponentLookup lookup, EventManager eventManager, PayloadVisualizationPanel payloadVisualizationPanel, InstallationPayloadsListView installationPayloadsListView, Provider<InstallationPayloadMenuExtension> installationPayloadMenuExtensionProvider, InstallationLoadingContext installationLoadingContext) {
        this.installationPayloadsListView = installationPayloadsListView;
        this.eventManager = eventManager;
        this.lookup = lookup;
        this.payloadVisualizationPanel = payloadVisualizationPanel;
        this.installationPayloadMenuExtensionProvider = installationPayloadMenuExtensionProvider;
        this.installationLoadingContext = installationLoadingContext;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.add((Component)((Object)this.installationPayloadsListView), "Center");
        this.add(this.payloadVisualizationPanel, "East");
        this.eventManager.addStrongListener(InstallationStateListener.class, (Object)new UpdateWarningIconOnInstallationChange());
        this.updateWarningIcon(((PayloadSettings)this.lookup.getComponent(PayloadSettings.class)).getInstallationDefaultPayload());
        this.installationPayloadsListView.setPayload3DUpdate(this.payloadVisualizationPanel);
    }

    public void setFlipManager(FlipManager flipManager) {
        super.setFlipManager(flipManager);
        this.installationPayloadsListView.setFlipManager(flipManager);
    }

    public void enter(Object o) {
        super.enter(o);
        this.installationPayloadsListView.enter(o);
        this.payloadVisualizationPanel.enter(o);
        this.refreshOnInstallationLoadSub.dispose();
        this.refreshOnInstallationLoadSub = this.eventManager.addStrongListener(InstallationStateListener.class, (Object)this.refreshOnInstallationLoad);
        this.updateComponents(null);
    }

    public Object exit() {
        this.refreshOnInstallationLoadSub.dispose();
        this.refreshOnInstallationLoadSub = Subscription.NULL;
        this.payloadVisualizationPanel.exit();
        this.installationPayloadsListView.exit();
        return super.exit();
    }

    private void updateComponents(Installation installation) {
        PayloadSettings service = installation == null ? (PayloadSettings)this.lookup.getComponent(PayloadSettings.class) : (PayloadSettings)installation.getComponent(PayloadSettings.class);
        InstallationPayloadComponent defaultPayload = service.getInstallationDefaultPayload();
        this.installationPayloadsListView.setDomain((DomainComponent)defaultPayload);
    }

    private void updateWarningIcon(InstallationPayloadComponent payload) {
        if (payload == null) {
            return;
        }
        Weight mass = payload.getMass();
        if (Weight.ZERO.equals((Object)mass)) {
            this.setIcon(ImageResource.formWarning(), (Component)((Object)this));
        } else {
            this.setIcon(ImageResource.blank(), (Component)((Object)this));
        }
    }

    private void setIcon(Icon icon, Component component) {
        if (this.installationPayloadMenuExtension == null) {
            this.installationPayloadMenuExtension = (InstallationPayloadMenuExtension)((Object)this.installationPayloadMenuExtensionProvider.get());
        }
        this.installationPayloadMenuExtension.setIcon(icon);
        this.eventManager.fireEvent(ShowIconListener.class, listener -> listener.setIcon(component, icon));
    }

    private class RefreshOnInstallationLoaded
    extends InstallationStateListener.Template {
        private RefreshOnInstallationLoaded() {
        }

        public void installationLoaded(Installation installation) {
            SwingUtil.invokeLater(() -> InstallationPayloadConfigurationTab.this.updateComponents(installation));
        }
    }

    private class UpdateWarningIconOnInstallationChange
    extends InstallationStateListener.Template {
        private UpdateWarningIconOnInstallationChange() {
        }

        public void installationLoaded(Installation installation) {
            SwingUtil.invokeLater(() -> InstallationPayloadConfigurationTab.this.updateWarningIcon(((PayloadSettings)installation.getComponent(PayloadSettings.class)).getInstallationDefaultPayload()));
        }

        public void installationModified() {
            if (!InstallationPayloadConfigurationTab.this.installationLoadingContext.isLoading()) {
                InstallationPayloadConfigurationTab.this.updateWarningIcon(((PayloadSettings)InstallationPayloadConfigurationTab.this.lookup.getComponent(PayloadSettings.class)).getInstallationDefaultPayload());
            }
        }
    }
}

