/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import com.ur.polyscope.payload.PayloadObserver;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;

public class InstallationPayloadNamingStrategy
extends NamingStrategy {
    private final NamingService namingService;
    private final EventManager eventManager;

    @Inject
    public InstallationPayloadNamingStrategy(NamingService namingService, EventManager eventManager) {
        super(InstallationPayloadComponent.class);
        this.namingService = namingService;
        this.eventManager = eventManager;
    }

    public void setName(NamedEntity entity, String nameCandidate) {
        if (StringUtils.isNullOrOnlyWhitespace((String)(nameCandidate = this.convertToValidName(nameCandidate)))) {
            return;
        }
        if (EqualsUtil.equals((Object)entity.getName(), (Object)nameCandidate) && !this.namingService.isReservedName(nameCandidate)) {
            return;
        }
        String newName = this.namingService.isNameUsed(entity.getClass(), nameCandidate) ? this.namingService.makeUniqueName(InstallationPayloadComponent.class, nameCandidate) : nameCandidate;
        String oldName = entity.getName();
        entity.setName(newName);
        this.fireNameChange((InstallationPayloadComponent)entity, oldName, newName);
    }

    private void fireNameChange(final InstallationPayloadComponent payload, final String oldName, final String newName) {
        this.eventManager.fireEvent(PayloadObserver.class, (NotificationStrategy)new NotificationStrategy<PayloadObserver>(){

            public void notify(PayloadObserver listener) {
                listener.nameChanged((NamedEntity)payload, oldName, newName);
            }
        });
    }
}

