/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation;

import com.ur.polyscope.payload.PayloadObserver;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.impl.urcapapi.PayloadPermanentReferenceOwner;
import com.ur.polyscope.payload.urcap.PayloadReferenceHandlingStrategyInternal;
import com.ur.polyscope.program.Program;
import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategy;
import com.ur.reference.ReferenceHandlingStrategyImpl;
import com.ur.reference.ReferenceOwner;
import com.ur.reference.ReferenceService;
import com.ur.util.event.EventManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PayloadReferenceHandlingStrategy
extends ReferenceHandlingStrategyImpl<String, InstallationPayloadComponent, PayloadReferenceComponent>
implements PayloadReferenceHandlingStrategyInternal {
    private final PayloadService payloadService;

    @Inject
    public PayloadReferenceHandlingStrategy(PayloadService payloadService, EventManager eventManager, @Program ReferenceService referenceService) {
        this.payloadService = payloadService;
        referenceService.registerReferenceStrategy(PayloadReferenceComponent.class, (ReferenceHandlingStrategy)this);
        eventManager.addStrongListener(PayloadObserver.class, (Object)new PayloadOwnerUpdater());
    }

    protected PayloadReferenceComponent createReference(String key) {
        return new PayloadReferenceComponent(key, this.payloadService);
    }

    protected String getKeyFor(InstallationPayloadComponent target) {
        return target.getName();
    }

    public boolean hasReference(String key) {
        return this.references.containsKey(key);
    }

    public void removeInvalidReferences() {
        HashMap validMap = new HashMap();
        for (String key : this.ownerMap.keySet()) {
            ArrayList<ReferenceOwner> validOwners = new ArrayList<ReferenceOwner>();
            Collection owners = (Collection)this.ownerMap.get(key);
            for (ReferenceOwner owner : owners) {
                if (owner instanceof PayloadPermanentReferenceOwner && !((PayloadPermanentReferenceOwner)owner).hasRealOwner()) continue;
                validOwners.add(owner);
            }
            validMap.put(key, validOwners);
        }
        this.ownerMap.clear();
        this.ownerMap.putAll(validMap);
    }

    public Map<String, PayloadReferenceComponent> getReferences() {
        return this.references;
    }

    public void clear() {
        ArrayList<PayloadPermanentReferenceOwner> permanentOwners = new ArrayList<PayloadPermanentReferenceOwner>();
        Collection owners = this.ownerMap.values();
        for (Collection ownersCollection : owners) {
            for (ReferenceOwner owner : ownersCollection) {
                if (!(owner instanceof PayloadPermanentReferenceOwner) || !((PayloadPermanentReferenceOwner)owner).hasRealOwner()) continue;
                PayloadPermanentReferenceOwner refOwner = (PayloadPermanentReferenceOwner)owner;
                permanentOwners.add(refOwner);
            }
        }
        super.clear();
        for (PayloadPermanentReferenceOwner owner : permanentOwners) {
            PayloadReferenceComponent newRef = this.createReference(owner.getKey());
            ArrayList<PayloadReferenceComponent> list = new ArrayList<PayloadReferenceComponent>();
            list.add(newRef);
            this.setOwnedReferences(owner, list);
        }
    }

    private class PayloadOwnerUpdater
    implements PayloadObserver {
        private PayloadOwnerUpdater() {
        }

        public void nameChanged(InstallationPayloadComponent entity, String oldName, String newName) {
            PayloadReferenceHandlingStrategy.this.keyChange(oldName, newName);
        }

        public void added(InstallationPayloadComponent payload) {
            PayloadReferenceHandlingStrategy.this.referenceChange((Reference)((PayloadReferenceComponent)PayloadReferenceHandlingStrategy.this.getReferenceTo(payload)));
        }

        public void removed(InstallationPayloadComponent payload) {
            PayloadReferenceHandlingStrategy.this.referenceChange((Reference)((PayloadReferenceComponent)PayloadReferenceHandlingStrategy.this.getReferenceTo(payload)));
        }
    }
}

