/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.installation.MissingPayloadException;
import com.ur.polyscope.payload.impl.installation.PayloadContributorInfoPersister;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.valueobjects.Weight;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class PayloadSettingsConversionStrategy
extends ConversionStrategyTemplate<PayloadSettings>
implements InstallationComponentConversionStrategy<PayloadSettings> {
    private static final String PAYLOAD_SETTINGS = "PayloadSettings";
    private static final String DEFAULT_PAYLOAD = "defaultPayload";
    private static final String PAYLOAD = "Payload";
    private static final String PAYLOAD_NAME = "name";
    private static final String PAYLOAD_MASS = "mass";
    private static final String PAYLOAD_CENTER_OF_GRAVITY = "centerOfGravity";
    private static final String PAYLOAD_INERTIA = "inertiaParameters";
    private static final String CUSTOM_INERTIA_ENABLED = "customInertiaEnabled";
    private final Provider<PayloadSettings> payloadSettingsProvider;
    private final PayloadContributorInfoPersister payloadContributorInfoPersister;

    @Inject
    public PayloadSettingsConversionStrategy(Provider<PayloadSettings> payloadSettingsProvider, PayloadContributorInfoPersister payloadContributorInfoPersister) {
        super(PayloadSettings.class);
        this.payloadSettingsProvider = payloadSettingsProvider;
        this.payloadContributorInfoPersister = payloadContributorInfoPersister;
    }

    public void marshal(PayloadSettings payloadSettings, PersistWriter writer) {
        InstallationPayloadComponent defaultInstallationPayload = payloadSettings.getInstallationDefaultPayload();
        if (defaultInstallationPayload == null) {
            return;
        }
        for (InstallationPayloadComponent payload : payloadSettings.getAllPayloads()) {
            writer.startNode(PAYLOAD);
            writer.addAttribute(PAYLOAD_NAME, payload.getName());
            writer.addAttribute(PAYLOAD_MASS, payload.getMass().asDouble());
            boolean isDefault = EqualsUtil.equals((Object)defaultInstallationPayload, (Object)payload);
            writer.addAttribute(DEFAULT_PAYLOAD, isDefault);
            double[] cogArray = new double[]{payload.getCenterOfGravity().getX(), payload.getCenterOfGravity().getY(), payload.getCenterOfGravity().getZ()};
            writer.addAttribute(PAYLOAD_CENTER_OF_GRAVITY, cogArray);
            Matrix3d inertiaValue = payload.getInertiaMatrix();
            double[] inertiaArray = new double[]{inertiaValue.m00, inertiaValue.m11, inertiaValue.m22, inertiaValue.m01, inertiaValue.m02, inertiaValue.m12};
            writer.addAttribute(PAYLOAD_INERTIA, inertiaArray);
            writer.addAttribute(CUSTOM_INERTIA_ENABLED, payload.isCustomInertiaEnabled());
            if (!payload.isUserDefined()) {
                this.payloadContributorInfoPersister.write(writer, payload.getContributorInfo());
            }
            writer.endNode();
        }
    }

    public PayloadSettings unmarshal(PersistReader reader) {
        PayloadSettings payloadSettings = (PayloadSettings)this.payloadSettingsProvider.get();
        if (!this.hasPayloads(reader)) {
            throw new MissingPayloadException("Installation has no payloads defined");
        }
        this.readPayloads(reader, payloadSettings);
        return payloadSettings;
    }

    private void readPayloads(PersistReader reader, PayloadSettings service) {
        while (reader.hasMoreNodes()) {
            ContributorInfo contributorInfo = null;
            reader.moveToChildNode();
            boolean isDefaultPayloadAvailable = reader.getBooleanAttribute(DEFAULT_PAYLOAD);
            String name = reader.getStringAttribute(PAYLOAD_NAME);
            double mass = reader.getDoubleAttribute(PAYLOAD_MASS);
            double[] cog = reader.getDoubleArrayAttribute(PAYLOAD_CENTER_OF_GRAVITY);
            double[] inertia = reader.getDoubleArrayAttribute(PAYLOAD_INERTIA);
            Matrix3d iMatrix = new Matrix3d(inertia[0], inertia[3], inertia[4], inertia[3], inertia[1], inertia[5], inertia[4], inertia[5], inertia[2]);
            boolean customInertiaEnabled = reader.getBooleanAttribute(CUSTOM_INERTIA_ENABLED);
            PayloadComponent basicPayload = new PayloadComponent(Weight.from((double)mass, (Weight.Unit)Weight.Unit.SI), new Vector3d(cog), iMatrix);
            if (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                contributorInfo = this.readContributionInfo(reader);
                reader.moveToParentNode();
            }
            InstallationPayloadComponent addedPayload = contributorInfo == null ? service.addPayload(name, basicPayload, InstallationPayloadComponent.UNKNOWN, customInertiaEnabled) : service.addPayload(name, basicPayload, contributorInfo, customInertiaEnabled);
            if (isDefaultPayloadAvailable) {
                service.setAsInstallationDefaultPayload(addedPayload);
            }
            reader.moveToParentNode();
        }
    }

    private boolean hasPayloads(PersistReader reader) {
        return reader.hasMoreNodes();
    }

    public Map<String, Class<? extends PayloadSettings>> getClassAliases(boolean forMarshalling) {
        LinkedHashMap<String, Class<? extends PayloadSettings>> aliasMap = new LinkedHashMap<String, Class<? extends PayloadSettings>>();
        aliasMap.put(PAYLOAD_SETTINGS, PayloadSettings.class);
        aliasMap.put("com.ur.polyscope.payload.impl.PayloadServiceImpl", PayloadSettings.class);
        return aliasMap;
    }

    public Map<String, Class<? extends PayloadSettings>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends PayloadSettings>> aliasMap = new HashMap<String, Class<? extends PayloadSettings>>();
        aliasMap.put(PAYLOAD_SETTINGS, PayloadSettings.class);
        return aliasMap;
    }

    private ContributorInfo readContributionInfo(PersistReader reader) {
        if (reader.getNodeName().equals("ContributorInfo")) {
            return this.payloadContributorInfoPersister.read(reader);
        }
        return null;
    }
}

