/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.domain;

import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.util.swing.HTML;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class InertiaInfoPanel
extends JPanel {
    private JLabel inertiaLabel;
    private final TextResource textResource;

    public InertiaInfoPanel(TextResource textResource) {
        this.textResource = textResource;
        this.initComponents();
    }

    private void initComponents() {
        this.setPanelLayout();
        this.add(this.createInertiaLabel());
    }

    private JLabel createInertiaLabel() {
        String inertiaDescription = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.inertiaDescription())));
        this.inertiaLabel = new JLabel(inertiaDescription, ImageResource.infoIcon(), 2);
        this.inertiaLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return this.inertiaLabel;
    }

    private void setPanelLayout() {
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(new EmptyBorder(5, 10, 10, 0));
        this.setPreferredSize(new Dimension(0, 70));
    }

    protected void updateInertiaDescription(PayloadComponent payloadComponent) {
        if (InertiaDecomposition.isValid(payloadComponent)) {
            String inertiaDescription = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.inertiaDescription())));
            this.inertiaLabel.setText(inertiaDescription);
            this.inertiaLabel.setIcon(ImageResource.infoIcon());
        } else {
            this.inertiaLabel.setText(HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.inertiaWarning()))));
            this.inertiaLabel.setIcon(ImageResource.formWarning());
        }
    }
}

