/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.domain;

import com.ur.injection.HasKey;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.TextResource;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.payload.impl.common.domain.PayloadValidationRulesImpl;
import com.ur.polyscope.payload.impl.common.internal.PayloadComboBoxContentHandler;
import com.ur.polyscope.payload.impl.installation.domain.InertiaInfoPanel;
import com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$1$AjcClosure1;
import com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$2$AjcClosure1;
import com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$3$AjcClosure1;
import com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$PayloadModifyListener$AjcClosure1;
import com.ur.polyscope.payload.impl.installation.domain.WarningPanel;
import com.ur.polyscope.payload.impl.installation.estimation.PayloadEstimationButtonPanel;
import com.ur.polyscope.payload.impl.installation.internal.PayloadNameValidator;
import com.ur.polyscope.payload.impl.installation.internal.PayloadsListCreator;
import com.ur.polyscope.payload.impl.installation.visualization.Payload3DUpdate;
import com.ur.polyscope.payload.impl.robotstate.ControllerSender;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotPayload;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@HasKey(value="payload-operations-installation")
public class InstallationPayloadsListView
extends CardPanel {
    private static final int BUTTON_WIDTH = 44;
    private static final int BUTTON_HEIGHT = 32;
    private static final int TOP_LINE_WIDTH = 500;
    private static final int TOP_LINE_HEIGHT = 50;
    private static final String HELP_ID_ADD_RENAME_REMOVE = "gui:installation:payload:add";
    private static final String HELP_ID_SET_ACTIVE = "gui:installation:payload:active";
    private static final String HELP_ID_DEFAULT = "gui:installation:payload:default";
    private static final String HELP_ID_PAYLOAD_SELECTION = "gui:installation:payload";
    private JButton addPayload;
    private JButton removePayload;
    private JButton renamePayload;
    private JButton applySelectedPayload;
    private JComboBox payloadListComboBox;
    private JButton setActiveButton;
    private final InstallationComponentLookup installationComponentLookup;
    private final ViewContext viewContext;
    private final ViewComponent payloadMassCogView;
    private final ViewComponent payloadInertiaView;
    private final PayloadEstimationButtonPanel payloadEstimationButtonPanel;
    private final ControllerSender controllerSender;
    private final RobotPayload robotPayload;
    private final HelpIdAssigner helpIdAssigner;
    private final TextResource payloadApiTextResource;
    private final PayloadComboBoxContentHandler payloadComboBoxContentHandler;
    private WarningPanel warningPanel;
    private InertiaInfoPanel inertiaInfoPanel;
    private Payload3DUpdate payload3DUpdate;
    private final PayloadValidationRulesImpl payloadValidationRules;

    @Inject
    public InstallationPayloadsListView(InstallationComponentLookup installationLookup, ViewContext viewContext, @Named(value="payload-mass-cog") @Named(value="payload-mass-cog") ViewComponent payloadMassCogView, @Named(value="payload-inertia") @Named(value="payload-inertia") ViewComponent payloadInertiaView, PayloadNameValidator payloadNameValidator, PayloadsListCreator payloadsListFactory, PayloadEstimationButtonPanel payloadEstimationButtonPanel, ControllerSender controllerSender, PayloadValidationRulesImpl payloadValidationRules, RobotConfigurationProvider robotConfigurationProvider) {
        this.installationComponentLookup = installationLookup;
        this.viewContext = viewContext;
        this.payloadMassCogView = payloadMassCogView;
        this.payloadInertiaView = payloadInertiaView;
        this.payloadEstimationButtonPanel = payloadEstimationButtonPanel;
        this.controllerSender = controllerSender;
        this.payloadValidationRules = payloadValidationRules;
        this.robotPayload = robotConfigurationProvider.getRobotPayload();
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.payloadApiTextResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.payloadComboBoxContentHandler = new PayloadComboBoxContentHandler((com.ur.polyscope.payload.internal.resources.TextResource)viewContext.getTextResource(com.ur.polyscope.payload.internal.resources.TextResource.class));
        this.createActionButtons(payloadsListFactory);
        this.createLayout();
        this.createActionListeners(payloadNameValidator);
        this.updatePayloadParameterView();
        payloadMassCogView.setModifyListener((ViewComponent.ModifyListener)new PayloadModifyListener(installationLookup));
        payloadInertiaView.setModifyListener((ViewComponent.ModifyListener)new PayloadModifyListener(installationLookup));
        payloadEstimationButtonPanel.setModifyListener(new PayloadModifyListener(installationLookup));
    }

    public void setFlipManager(FlipManager flipManager) {
        super.setFlipManager(flipManager);
        this.payloadEstimationButtonPanel.setFlipManager(flipManager);
    }

    public void setPayload3DUpdate(Payload3DUpdate payload3DUpdate) {
        this.payload3DUpdate = payload3DUpdate;
    }

    private void createLayout() {
        com.ur.polyscope.payload.internal.resources.TextResource textResource = (com.ur.polyscope.payload.internal.resources.TextResource)this.viewContext.getTextResource(com.ur.polyscope.payload.internal.resources.TextResource.class);
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.setBorder((Border)new CardBorder(textResource.payload()));
        this.warningPanel = new WarningPanel(this.payloadApiTextResource, this.robotPayload, this.payloadValidationRules);
        this.inertiaInfoPanel = new InertiaInfoPanel(textResource);
        this.warningPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.add(this.createTopLine());
        this.add(this.createMassCogInertiaPanel());
        this.add(this.warningPanel);
        this.add(this.createInertiaPanel());
        this.add(this.inertiaInfoPanel);
    }

    private JPanel createMassCogInertiaPanel() {
        JPanel massCogPanel = new JPanel();
        massCogPanel.setLayout(new BoxLayout(massCogPanel, 2));
        JComponent payloadDetailsView = this.payloadMassCogView.asComponent();
        payloadDetailsView.setBorder(new EmptyBorder(15, 10, 0, 0));
        this.setActiveButton.setAlignmentY(0.0f);
        JPanel estimationPanel = this.viewContext.createFormBuilder().component((JComponent)this.setActiveButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_ROW}).end(1).component(this.payloadEstimationButtonPanel.asComponent(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_ROWS}).end(7).getPanel();
        estimationPanel.setMaximumSize(new Dimension(199, 219));
        estimationPanel.setPreferredSize(new Dimension(199, 210));
        estimationPanel.setBorder(new EmptyBorder(0, 0, 0, 13));
        massCogPanel.add(payloadDetailsView);
        massCogPanel.add(estimationPanel);
        massCogPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return massCogPanel;
    }

    private JPanel createInertiaPanel() {
        JPanel inertiaPanel = new JPanel();
        inertiaPanel.setLayout(new BoxLayout(inertiaPanel, 2));
        JComponent inertiaView = this.payloadInertiaView.asComponent();
        inertiaView.setBorder(new EmptyBorder(0, 10, 0, 0));
        inertiaPanel.add(inertiaView);
        inertiaPanel.add(Box.createRigidArea(new Dimension(164, 1)));
        inertiaPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return inertiaPanel;
    }

    private JPanel createTopLine() {
        JPanel topline = this.viewContext.createFormBuilder().component((JComponent)this.renamePayload, new FormBuilder.PanelConstraints[0]).spacer().component((JComponent)this.payloadListComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).spacer().component((JComponent)this.applySelectedPayload, new FormBuilder.PanelConstraints[0]).component((JComponent)this.addPayload, new FormBuilder.PanelConstraints[0]).component((JComponent)this.removePayload, new FormBuilder.PanelConstraints[0]).end().groupColumns(new int[]{1, 3, 9, 11, 12}).spacer().end().getPanel();
        topline.setBorder(new EmptyBorder(15, 10, 5, 10));
        this.setToplineDimensions(topline);
        return topline;
    }

    public void enter(Object o) {
        super.enter(o);
        this.updateButtonStates();
        this.updatePayload3DView((PayloadComponent)this.payloadListComboBox.getSelectedItem());
    }

    private void updateButtonStates() {
        this.applySelectedPayload.setEnabled(this.isApplySelectedPayloadEnabled());
        this.setActiveButton.setEnabled(this.isActivePayloadEnabled() && this.isInertiaValid());
        this.removePayload.setEnabled(this.isSelectedPayloadEditable() && this.payloadListComboBox.getModel().getSize() > 1);
        this.renamePayload.setEnabled(this.isSelectedPayloadEditable());
    }

    private void setToplineDimensions(JPanel topline) {
        Dimension panelSize = new Dimension(500, 50);
        topline.setMaximumSize(panelSize);
        topline.setMinimumSize(panelSize);
        topline.setPreferredSize(panelSize);
    }

    private void createActionButtons(PayloadsListCreator payloadsListCreator) {
        this.renamePayload = new JButton(ImageResource.rename());
        this.renamePayload.setName(com.ur.polyscope.application.driver.payload.names.InstallationPayloadsListView.RENAME_PAYLOAD);
        this.renamePayload.setPreferredSize(new Dimension(44, 32));
        this.renamePayload.setFocusable(false);
        this.helpIdAssigner.assignHelpId((JComponent)this.renamePayload, HELP_ID_ADD_RENAME_REMOVE);
        this.payloadListComboBox = payloadsListCreator.getPayloadsList();
        this.payloadListComboBox.addActionListener(e -> {
            this.updatePayloadParameterView();
            this.updatePayload3DView((PayloadComponent)this.payloadListComboBox.getSelectedItem());
            this.updateButtonStates();
        });
        this.helpIdAssigner.assignHelpId((JComponent)this.payloadListComboBox, HELP_ID_PAYLOAD_SELECTION);
        this.applySelectedPayload = new JButton(ImageResource.defaultIcon());
        this.applySelectedPayload.setName(com.ur.polyscope.application.driver.payload.names.InstallationPayloadsListView.APPLY_SELECTED_PAYLOAD);
        this.applySelectedPayload.setPreferredSize(new Dimension(44, 32));
        this.applySelectedPayload.setFocusable(false);
        this.helpIdAssigner.assignHelpId((JComponent)this.applySelectedPayload, HELP_ID_DEFAULT);
        this.setActiveButton = new JButton(((com.ur.polyscope.payload.internal.resources.TextResource)this.viewContext.getTextResource(com.ur.polyscope.payload.internal.resources.TextResource.class)).setNow(), ImageResource.setactive());
        this.setActiveButton.setName(com.ur.polyscope.application.driver.payload.names.InstallationPayloadsListView.SET_ACTIVE_PAYLOAD);
        this.setActiveButton.setFocusable(false);
        this.setActiveButton.addActionListener(e -> {
            if (this.payloadListComboBox.getSelectedItem() != null) {
                this.controllerSender.sendSetToolPayload((DomainComponent)((PayloadComponent)this.payloadListComboBox.getSelectedItem()));
                this.updateButtonStates();
            }
        });
        this.helpIdAssigner.assignHelpId((JComponent)this.setActiveButton, HELP_ID_SET_ACTIVE);
        this.addPayload = new JButton(ImageResource.gtkAdd());
        this.addPayload.setName(com.ur.polyscope.application.driver.payload.names.InstallationPayloadsListView.ADD_PAYLOAD);
        this.addPayload.setPreferredSize(new Dimension(44, 32));
        this.addPayload.setFocusable(false);
        this.helpIdAssigner.assignHelpId((JComponent)this.addPayload, HELP_ID_ADD_RENAME_REMOVE);
        this.removePayload = new JButton(ImageResource.delete());
        this.removePayload.setName(com.ur.polyscope.application.driver.payload.names.InstallationPayloadsListView.REMOVE_PAYLOAD);
        this.removePayload.setPreferredSize(new Dimension(44, 32));
        this.removePayload.setFocusable(false);
        this.removePayload.setEnabled(false);
        this.helpIdAssigner.assignHelpId((JComponent)this.removePayload, HELP_ID_ADD_RENAME_REMOVE);
    }

    private boolean isApplySelectedPayloadEnabled() {
        PayloadComponent selectedPayload = (PayloadComponent)this.payloadListComboBox.getSelectedItem();
        InstallationPayloadComponent defaultPayload = ((PayloadSettings)this.installationComponentLookup.getComponent(PayloadSettings.class)).getInstallationDefaultPayload();
        return !defaultPayload.equals((Object)selectedPayload) && this.isInertiaValid();
    }

    private boolean isSelectedPayloadEditable() {
        if (this.payloadListComboBox.getSelectedItem() != null) {
            return ((PayloadComponent)this.payloadListComboBox.getSelectedItem()).isUserDefined();
        }
        return true;
    }

    private boolean isActivePayloadEnabled() {
        PayloadComponent selectedPayload = (PayloadComponent)this.payloadListComboBox.getSelectedItem();
        PayloadComponent activePayload = ((PayloadSettings)this.installationComponentLookup.getComponent(PayloadSettings.class)).getActivePayload();
        return activePayload != null && !activePayload.equals((Object)selectedPayload);
    }

    private void updatePayloadParameterView() {
        PayloadComponent selected = (PayloadComponent)this.payloadListComboBox.getSelectedItem();
        this.payloadMassCogView.setDomain((DomainComponent)selected);
        this.payloadInertiaView.setDomain((DomainComponent)selected);
        this.payloadEstimationButtonPanel.setDomain((DomainComponent)selected);
        if (selected != null) {
            this.warningPanel.updateWarning(selected.getMass(), selected.getCenterOfGravity());
            this.inertiaInfoPanel.updateInertiaDescription(selected);
        }
    }

    private void updatePayload3DView(PayloadComponent payloadComponent) {
        if (this.payload3DUpdate == null) {
            return;
        }
        if (this.isShowing()) {
            this.payload3DUpdate.setSelectedPayload(payloadComponent);
        }
    }

    private boolean isInertiaValid() {
        PayloadComponent selectedPayload = (PayloadComponent)this.payloadListComboBox.getSelectedItem();
        return selectedPayload == null || InertiaDecomposition.isValid(selectedPayload);
    }

    private void createActionListeners(PayloadNameValidator payloadNameValidator) {
        this.addPayload.addActionListener(new ActionListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @InstallationChangedEvent
            public void actionPerformed(ActionEvent e) {
                ActionEvent actionEvent = e;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)actionEvent);
                Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
                InstallationPayloadsListView$1$AjcClosure1 installationPayloadsListView$1$AjcClosure1 = new InstallationPayloadsListView$1$AjcClosure1(objectArray);
                InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(installationPayloadsListView$1$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ void actionPerformed_aroundBody0(1 ajc$this, ActionEvent e, JoinPoint joinPoint) {
                InstallationPayloadComponent newPayload = ((PayloadSettings)ajc$this.InstallationPayloadsListView.this.installationComponentLookup.getComponent(PayloadSettings.class)).addPayload();
                ajc$this.InstallationPayloadsListView.this.payloadListComboBox.setModel(ajc$this.InstallationPayloadsListView.this.getPayloadModel());
                ajc$this.InstallationPayloadsListView.this.payloadListComboBox.setSelectedItem(newPayload);
                ajc$this.InstallationPayloadsListView.this.payloadMassCogView.setDomain((DomainComponent)newPayload);
                ajc$this.InstallationPayloadsListView.this.payloadInertiaView.setDomain((DomainComponent)newPayload);
                ajc$this.InstallationPayloadsListView.this.payloadEstimationButtonPanel.setDomain((DomainComponent)newPayload);
                ajc$this.InstallationPayloadsListView.this.updateButtonStates();
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("InstallationPayloadsListView.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$1", "java.awt.event.ActionEvent", "e", "", "void"), 311);
            }
        });
        this.removePayload.addActionListener(new ActionListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @InstallationChangedEvent
            public void actionPerformed(ActionEvent e) {
                ActionEvent actionEvent = e;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)actionEvent);
                Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
                InstallationPayloadsListView$2$AjcClosure1 installationPayloadsListView$2$AjcClosure1 = new InstallationPayloadsListView$2$AjcClosure1(objectArray);
                InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(installationPayloadsListView$2$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                2.ajc$preClinit();
            }

            static final /* synthetic */ void actionPerformed_aroundBody0(2 ajc$this, ActionEvent e, JoinPoint joinPoint) {
                InstallationPayloadComponent selectedPayload;
                PayloadSettings payloadSettings = (PayloadSettings)ajc$this.InstallationPayloadsListView.this.installationComponentLookup.getComponent(PayloadSettings.class);
                boolean removed = payloadSettings.removePayload(selectedPayload = (InstallationPayloadComponent)ajc$this.InstallationPayloadsListView.this.payloadListComboBox.getSelectedItem());
                if (!removed) {
                    return;
                }
                boolean setActive = selectedPayload == payloadSettings.getInstallationDefaultPayload();
                MutableComboBoxModel model = (MutableComboBoxModel)ajc$this.InstallationPayloadsListView.this.payloadListComboBox.getModel();
                model.removeElement(selectedPayload);
                if (setActive) {
                    model.setSelectedItem(payloadSettings.getInstallationDefaultPayload());
                }
                ajc$this.InstallationPayloadsListView.this.updateButtonStates();
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("InstallationPayloadsListView.java", 2.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$2", "java.awt.event.ActionEvent", "e", "", "void"), 325);
            }
        });
        TextHolder provider = this.createTextHolder();
        TextFieldUtils.bindTextPicker((JComponent)this.renamePayload, (TextHolder)provider, (ValidationStrategy)payloadNameValidator.getPayloadNameValidationStrategy(this.payloadListComboBox));
        this.applySelectedPayload.addActionListener(new ActionListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @InstallationChangedEvent
            public void actionPerformed(ActionEvent event) {
                ActionEvent actionEvent = event;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)actionEvent);
                Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
                InstallationPayloadsListView$3$AjcClosure1 installationPayloadsListView$3$AjcClosure1 = new InstallationPayloadsListView$3$AjcClosure1(objectArray);
                InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(installationPayloadsListView$3$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                3.ajc$preClinit();
            }

            static final /* synthetic */ void actionPerformed_aroundBody0(3 ajc$this, ActionEvent event, JoinPoint joinPoint) {
                InstallationPayloadComponent selectedItem = (InstallationPayloadComponent)ajc$this.InstallationPayloadsListView.this.payloadListComboBox.getSelectedItem();
                try {
                    ((PayloadSettings)ajc$this.InstallationPayloadsListView.this.installationComponentLookup.getComponent(PayloadSettings.class)).setAsInstallationDefaultPayload(selectedItem);
                    ajc$this.InstallationPayloadsListView.this.payloadListComboBox.repaint();
                    ajc$this.InstallationPayloadsListView.this.updateButtonStates();
                }
                catch (Exception exception) {
                    Log.error((String)"Write failed in PayloadTab:PayloadUpdate");
                }
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("InstallationPayloadsListView.java", 3.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$3", "java.awt.event.ActionEvent", "event", "", "void"), 350);
            }
        });
    }

    public void setDomain(DomainComponent domainComponent) {
        this.payloadListComboBox.setModel(this.getPayloadModel());
        if (domainComponent != null) {
            this.payloadListComboBox.setSelectedItem(domainComponent);
        }
        this.updatePayloadParameterView();
        this.updateButtonStates();
    }

    private DefaultComboBoxModel getPayloadModel() {
        PayloadSettings payloadSettings = (PayloadSettings)this.installationComponentLookup.getComponent(PayloadSettings.class);
        return this.payloadComboBoxContentHandler.getPayloadComboBoxModel(payloadSettings.getAllPayloads());
    }

    private TextHolder createTextHolder() {
        return new TextHolder(){

            public String getText() {
                Object selectedItem = InstallationPayloadsListView.this.payloadListComboBox.getSelectedItem();
                if (selectedItem instanceof InstallationPayloadComponent) {
                    return ((InstallationPayloadComponent)selectedItem).getName();
                }
                return "";
            }

            public void setText(String text) {
                PayloadSettings payloadSettings = (PayloadSettings)InstallationPayloadsListView.this.installationComponentLookup.getComponent(PayloadSettings.class);
                InstallationPayloadComponent defaultPayload = payloadSettings.getInstallationDefaultPayload();
                Object selectedItem = InstallationPayloadsListView.this.payloadListComboBox.getModel().getSelectedItem();
                if (selectedItem instanceof InstallationPayloadComponent) {
                    InstallationPayloadComponent payload = (InstallationPayloadComponent)selectedItem;
                    payload.setName(text);
                    InstallationPayloadsListView.this.payloadListComboBox.setModel(InstallationPayloadsListView.this.getPayloadModel());
                    InstallationPayloadsListView.this.payloadListComboBox.getModel().setSelectedItem(payload);
                    if (defaultPayload == selectedItem) {
                        payloadSettings.setAsInstallationDefaultPayload(defaultPayload);
                    }
                }
            }
        };
    }

    private class PayloadModifyListener
    implements ViewComponent.ModifyListener {
        private final InstallationComponentLookup installationLookup;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public PayloadModifyListener(InstallationComponentLookup installationLookup) {
            this.installationLookup = installationLookup;
        }

        @InstallationChangedEvent
        public void onModified(DomainComponent domainComponent) {
            DomainComponent domainComponent2 = domainComponent;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)domainComponent2);
            Object[] objectArray = new Object[]{this, domainComponent2, joinPoint};
            InstallationPayloadsListView$PayloadModifyListener$AjcClosure1 installationPayloadsListView$PayloadModifyListener$AjcClosure1 = new InstallationPayloadsListView$PayloadModifyListener$AjcClosure1(objectArray);
            InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(installationPayloadsListView$PayloadModifyListener$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        static {
            PayloadModifyListener.ajc$preClinit();
        }

        static final /* synthetic */ void onModified_aroundBody0(PayloadModifyListener ajc$this, DomainComponent domainComponent, JoinPoint joinPoint) {
            InstallationPayloadComponent payloadToBeModified = (InstallationPayloadComponent)ajc$this.InstallationPayloadsListView.this.payloadListComboBox.getSelectedItem();
            PayloadSettings service = (PayloadSettings)ajc$this.installationLookup.getComponent(PayloadSettings.class);
            InstallationPayloadComponent toBeUpdated = new InstallationPayloadComponent(payloadToBeModified.getName(), (PayloadComponent)domainComponent, payloadToBeModified.getContributorInfo(), ((PayloadComponent)domainComponent).isCustomInertiaEnabled());
            InstallationPayloadComponent finallyUpdated = service.updatePayloadParameters(toBeUpdated);
            ajc$this.InstallationPayloadsListView.this.payloadListComboBox.setModel(ajc$this.InstallationPayloadsListView.this.getPayloadModel());
            ajc$this.InstallationPayloadsListView.this.payloadListComboBox.setSelectedItem(finallyUpdated);
            ajc$this.InstallationPayloadsListView.this.warningPanel.updateWarning(finallyUpdated.getMass(), finallyUpdated.getCenterOfGravity());
            ajc$this.InstallationPayloadsListView.this.inertiaInfoPanel.updateInertiaDescription((PayloadComponent)finallyUpdated);
            ajc$this.InstallationPayloadsListView.this.setActiveButton.setEnabled(ajc$this.InstallationPayloadsListView.this.isActivePayloadEnabled() && ajc$this.InstallationPayloadsListView.this.isInertiaValid());
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("InstallationPayloadsListView.java", PayloadModifyListener.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onModified", "com.ur.polyscope.payload.impl.installation.domain.InstallationPayloadsListView$PayloadModifyListener", "com.ur.polyscope.application.DomainComponent", "domainComponent", "", "void"), 415);
        }
    }
}

