/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.domain;

import com.ur.injection.HasKey;
import com.ur.lang.Defense;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.payload.impl.common.internal.WeightInputFactory;
import com.ur.polyscope.payload.impl.common.view.PayloadSelectionView;
import com.ur.polyscope.payload.impl.common.view.PayloadValidationStrategy;
import com.ur.polyscope.payload.impl.installation.internal.ActivePayloadViewHelper;
import com.ur.polyscope.payload.impl.robotstate.ControllerSender;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.NotImplementedException;

@HasKey(value="payload-initialization")
public class PayloadInitializationView
extends ControllerSender
implements ViewComponent {
    private static final ValidationStrategy REMOVE_VALIDATION_STRATEGY = null;
    private final JPanel parameterPanel;
    private final NumberField weightTextField;
    private final PayloadSelectionView payloadSelectionView;
    private final InstallationComponentLookup installationComponentLookup;
    private final ValidationStrategy weightTextFieldWarningStrategy;
    private DomainComponent lastSelectedInstallationPayload;

    @Inject
    public PayloadInitializationView(ViewContext viewContext, ControllerInterface controllerInterface, PayloadSelectionView installationPayloadSelectionView, WeightInputFactory weightInputFactory, PayloadValidationStrategy payloadValidationStrategy, InstallationComponentLookup installationComponentLookup) {
        super(controllerInterface);
        this.installationComponentLookup = installationComponentLookup;
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.payloadSelectionView = installationPayloadSelectionView;
        this.payloadSelectionView.setModifyListener(new PayloadChanged());
        JComponent payloadSelectionComponent = this.payloadSelectionView.asComponent();
        ActivePayloadControllerSender payloadUpdateAction = new ActivePayloadControllerSender();
        this.weightTextField = weightInputFactory.getEntryField(payloadUpdateAction);
        this.weightTextFieldWarningStrategy = new ValidationStrategy.Composite(new ValidationStrategy[]{this.weightTextField.getWarningValidationStrategy(), payloadValidationStrategy});
        JPanel topPanel = ActivePayloadViewHelper.getActivePayloadExplanation(textResource, viewContext);
        JPanel centerPanel = viewContext.createFormBuilder().label(textResource.activePayload(), new FormBuilder.PanelConstraints[0]).component(payloadSelectionComponent, new FormBuilder.PanelConstraints[0]).end().end().componentWithLabel(textResource.payload(), (JComponent)this.weightTextField, new FormBuilder.PanelConstraints[0]).end().getPanel();
        this.parameterPanel = new JPanel(new BorderLayout());
        this.parameterPanel.add((Component)topPanel, "First");
        this.parameterPanel.add((Component)centerPanel, "Center");
        this.enableEditInputs(false);
    }

    public JComponent asComponent() {
        return this.parameterPanel;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        throw new NotImplementedException("Notifications not supported");
    }

    public void setDomain(DomainComponent activePayloadComponent) {
        Defense.notNull((Object)activePayloadComponent);
        this.lastSelectedInstallationPayload = activePayloadComponent;
        this.updateWeightValidator();
        this.payloadSelectionView.setDomain(activePayloadComponent);
        this.setInputValues(activePayloadComponent);
        this.enableEditInputs(this.isPayloadInstallationSelected());
    }

    private void setInputValues(DomainComponent payloadComponent) {
        PayloadComponent payload = (PayloadComponent)payloadComponent;
        this.weightTextField.setValue((Object)payload.getMass());
    }

    private void updateWeightValidator() {
        if (this.isPayloadInstallationSelected()) {
            this.setWeightWarningStrategy();
        } else {
            this.removeWeightWarningStrategy();
        }
    }

    private boolean isPayloadInstallationSelected() {
        return this.lastSelectedInstallationPayload instanceof PayloadComponent;
    }

    private void enableEditInputs(boolean enable) {
        this.weightTextField.setEnabled(enable);
    }

    private void setWeightWarningStrategy() {
        this.weightTextField.setWarningValidationStrategy(new ValidationStrategy[]{this.weightTextFieldWarningStrategy});
    }

    private void removeWeightWarningStrategy() {
        this.weightTextField.setWarningValidationStrategy(new ValidationStrategy[]{REMOVE_VALIDATION_STRATEGY});
    }

    private class ActivePayloadControllerSender
    implements ActionListener {
        private ActivePayloadControllerSender() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Weight weight = (Weight)PayloadInitializationView.this.weightTextField.getValue();
            PayloadSettings payloadSettings = (PayloadSettings)PayloadInitializationView.this.installationComponentLookup.getComponent(PayloadSettings.class);
            PayloadComponent activePayload = payloadSettings.getActivePayload();
            PayloadInitializationView.this.sendSetToolPayload((DomainComponent)new PayloadComponent(weight, activePayload.getCenterOfGravity(), activePayload.getInertiaMatrix()));
        }
    }

    private class PayloadChanged
    implements ViewComponent.ModifyListener {
        private PayloadChanged() {
        }

        public void onModified(DomainComponent domainComponent) {
            PayloadInitializationView.this.lastSelectedInstallationPayload = domainComponent;
            PayloadInitializationView.this.enableEditInputs(PayloadInitializationView.this.isPayloadInstallationSelected());
            PayloadInitializationView.this.setInputValues(domainComponent);
            PayloadInitializationView.this.updateWeightValidator();
            if (PayloadInitializationView.this.isPayloadInstallationSelected()) {
                PayloadInitializationView.this.sendSetToolPayload(PayloadInitializationView.this.lastSelectedInstallationPayload);
            } else if (this.canSendToController(domainComponent)) {
                PayloadInitializationView.this.sendSetToolPayload(domainComponent);
            }
        }

        private boolean canSendToController(DomainComponent domainComponent) {
            boolean result = domainComponent.isDefined();
            if (domainComponent instanceof PayloadComponent) {
                result &= InertiaDecomposition.isValid((PayloadComponent)domainComponent);
            }
            return result;
        }
    }
}

