/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.domain;

import com.ur.polyscope.application.driver.payload.names.PayloadReferenceView;
import com.ur.polyscope.payload.TextResource;
import com.ur.polyscope.payload.impl.common.domain.PayloadValidationRulesImpl;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.robot.configuration.RobotPayload;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.util.swing.HTML;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class WarningPanel
extends JPanel {
    private final JLabel warningLabel;
    private final PayloadValidationRulesImpl payloadValidationRules;
    private final Weight maxPayloadSoftLimitSI;
    private final String rememberPayloadWarning;
    private final String payloadExeededWarning;
    private final String combinedMassAndCogWarning;
    private final String errorInInstallationPayloadMsg;
    private final String payloadCogComboAffectPerformanceWarning;

    public WarningPanel(TextResource textResource, RobotPayload robotPayload, PayloadValidationRulesImpl payloadValidationRules) {
        this.payloadValidationRules = payloadValidationRules;
        ValueConverter weightConverter = UnitsValueConverterFactory.getWeightConverter();
        this.maxPayloadSoftLimitSI = Weight.from((double)robotPayload.getMaximumPayload(false).asDouble(), (Weight.Unit)Weight.Unit.SI);
        String maxPayloadConverted = weightConverter.getFormat().format(Double.parseDouble((String)weightConverter.fromModel((Object)this.maxPayloadSoftLimitSI)));
        String unit = weightConverter.getUnit();
        this.rememberPayloadWarning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)textResource.rememberPayloadWarning())));
        this.payloadExeededWarning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)textResource.ratedpPayloadExceeded(maxPayloadConverted, unit))));
        this.combinedMassAndCogWarning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)textResource.payloadAndCogWarning())));
        this.errorInInstallationPayloadMsg = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)textResource.payloadHasErrorInInstallation())));
        this.payloadCogComboAffectPerformanceWarning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)textResource.payloadCogComboAffectPerformanceWarning())));
        String warning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)textResource.payloadAndCogWarning())));
        this.warningLabel = new JLabel(warning, ImageResource.formWarning(), 2);
        this.warningLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.warningLabel.setName(PayloadReferenceView.PAYLOAD_WARNING_LABEL);
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createRigidArea(new Dimension(0, 40)));
        this.add(this.warningLabel);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void updateWarning(Weight mass, Vector3d cog) {
        String warning = this.getWarningTextForMassValidation(mass);
        if (warning.equals("") && !this.payloadValidationRules.isMassAndCOGValid((Mass)mass, cog)) {
            warning = this.combinedMassAndCogWarning;
        }
        this.warningLabel.setText(warning);
        this.warningLabel.setIcon(ImageResource.formWarning());
        boolean showWarning = !warning.equals("");
        this.warningLabel.setVisible(showWarning);
    }

    private String getWarningTextForMassValidation(Weight mass) {
        String warning = "";
        if (this.payloadValidationRules.isMassZero((Mass)mass)) {
            warning = this.rememberPayloadWarning;
        } else if (this.payloadValidationRules.isMassAboveUpperSoftLimit((Mass)mass)) {
            warning = this.payloadExeededWarning;
        }
        return warning;
    }

    public void updateWarningOrErrorMessage(Weight mass, Vector3d cog, Matrix3d inertiaMatrix) {
        String text = this.getWarningTextForMassValidation(mass);
        boolean showError = false;
        if (text.equals("")) {
            if (!this.payloadValidationRules.isMassAndCOGValid((Mass)mass, cog)) {
                text = this.payloadCogComboAffectPerformanceWarning;
            } else if (!this.payloadValidationRules.isMassAndCOGAndInertiaValid((Mass)mass, cog, inertiaMatrix)) {
                text = this.errorInInstallationPayloadMsg;
                showError = true;
            }
        }
        Icon icon = showError ? ImageResource.gtkCancel() : ImageResource.formWarning();
        this.warningLabel.setIcon(icon);
        this.warningLabel.setText(text);
        boolean showWarning = !text.equals("");
        this.warningLabel.setVisible(showWarning || showError);
    }

    public void setInvisible() {
        this.warningLabel.setVisible(false);
    }
}

