/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.estimation;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.domain.SphereOfWaterInertia;
import com.ur.polyscope.payload.impl.installation.estimation.PayloadEstimationWizardCallback;
import com.ur.polyscope.payload.impl.installation.estimation.PayloadEstimationWizardCardPanel;
import com.ur.polyscope.payload.impl.robotstate.ControllerSender;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.util.swing.HTML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.vecmath.Vector3d;

@Singleton
public class PayloadEstimationButtonPanel
extends CardPanel
implements ViewComponent {
    private static final String HELP_ID_ESTIMATION = "gui:installation:payload:estimation";
    private final ViewContext viewContext;
    private final PoweredOnRobotRequirement poweredOnRobotRequirement;
    private final ControllerSender controllerSender;
    private ViewComponent.ModifyListener modifyListener;
    private PayloadComponent payload;
    private JButton payloadEstimationButton;

    @Inject
    public PayloadEstimationButtonPanel(ViewContext viewContext, PoweredOnRobotRequirement poweredOnRobotRequirement, ControllerSender controllerSender) {
        this.viewContext = viewContext;
        this.poweredOnRobotRequirement = poweredOnRobotRequirement;
        this.controllerSender = controllerSender;
        this.createWizardButton();
    }

    private void createWizardButton() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.payloadEstimationButton = new JButton(HTML.html((String)textResource.measure()), ImageResource.wizardIcon());
        this.payloadEstimationButton.setName(com.ur.polyscope.application.driver.payload.names.PayloadEstimationButtonPanel.PAYLOAD_ESTIMATION);
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.payloadEstimationButton, HELP_ID_ESTIMATION);
        this.payloadEstimationButton.addActionListener(new PayloadEstimationActionListener());
        this.payloadEstimationButton.setBorder(new CompoundBorder(new EmptyBorder(9, 0, 13, 0), this.payloadEstimationButton.getBorder()));
    }

    public JComponent asComponent() {
        return this.payloadEstimationButton;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setDomain(DomainComponent payload) {
        this.payload = (PayloadComponent)payload;
        if (payload != null) {
            this.payloadEstimationButton.setEnabled(this.payload.isUserDefined());
        }
    }

    private class PayloadEstimationActionListener
    implements ActionListener {
        private PayloadEstimationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PayloadEstimationButtonPanel.this.poweredOnRobotRequirement.checkAndNotify()) {
                PayloadEstimationButtonPanel.this.flipManager.stackCurrentCardAndSwitchTo(PayloadEstimationWizardCardPanel.class, (Object)new PayloadEstimationWizardCallback(){

                    @Override
                    public void onOk(Weight mass, Vector3d cog) {
                        PayloadComponent oldPayload = PayloadEstimationButtonPanel.this.payload;
                        PayloadEstimationButtonPanel.this.payload = new PayloadComponent(new PayloadComponent(mass, cog, SphereOfWaterInertia.getInertiaMatrix(mass.asDouble())));
                        if (!PayloadEstimationButtonPanel.this.payload.equals((Object)oldPayload)) {
                            PayloadEstimationButtonPanel.this.modifyListener.onModified((DomainComponent)PayloadEstimationButtonPanel.this.payload);
                            PayloadEstimationButtonPanel.this.controllerSender.sendSetToolPayload((DomainComponent)PayloadEstimationButtonPanel.this.payload);
                        }
                    }

                    @Override
                    public void onCancel() {
                    }
                });
            }
        }
    }
}

