/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.estimation;

import com.ur.polyscope.payload.impl.installation.estimation.entities.PayloadEstimationModel;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.NumberField;
import com.ur.swing.wizard.AbstractWizardPage;
import com.ur.swing.wizard.ButtonEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PayloadEstimationFinaliseWizardPage
extends AbstractWizardPage {
    private final PayloadEstimationModel payloadEstimationModel;
    private WidgetFactory widgetFactory;
    private final TextResource textResource;
    private JLabel stateLabel;
    private NumberField payloadTextField;
    private NumberField cogXTextField;
    private NumberField cogYTextField;
    private NumberField cogZTextField;

    public PayloadEstimationFinaliseWizardPage(String title, TextResource textResource, PayloadEstimationModel payloadEstimationModel, WidgetFactory widgetFactory) {
        super(title);
        this.textResource = textResource;
        this.payloadEstimationModel = payloadEstimationModel;
        this.widgetFactory = widgetFactory;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.stateLabel = new JLabel();
        this.stateLabel.setAlignmentX(0.5f);
        this.stateLabel.setHorizontalAlignment(0);
        this.stateLabel.setName(String.valueOf(PayloadEstimationFinaliseWizardPage.class.getSimpleName()) + ".stateLabel");
        JPanel statePanel = new JPanel();
        statePanel.setAlignmentX(0.5f);
        statePanel.add(this.stateLabel);
        Box descriptionPanel = Box.createVerticalBox();
        descriptionPanel.setAlignmentX(0.5f);
        descriptionPanel.add(AbstractWizardPage.toHTMLFormattedJLabel((String)this.textResource.payloadEstimationWizardFinishDescription()));
        JLabel payloadLabel = new JLabel(this.textResource.payload());
        payloadLabel.setAlignmentX(0.5f);
        this.payloadTextField = this.widgetFactory.createNumberField(null, UnitsValueConverterFactory.getWeightConverter());
        this.payloadTextField.setColumns(8);
        this.payloadTextField.setHorizontalAlignment(4);
        this.payloadTextField.setEditable(false);
        this.payloadTextField.setName(String.valueOf(PayloadEstimationFinaliseWizardPage.class.getSimpleName()) + ".payloadTextField");
        JPanel payloadComponent = new JPanel();
        payloadComponent.setAlignmentX(0.5f);
        payloadComponent.add(Box.createHorizontalStrut(20));
        payloadComponent.add((Component)this.payloadTextField);
        JLabel cogLabel = new JLabel(this.textResource.CenterOfGravity());
        cogLabel.setAlignmentX(0.5f);
        JLabel cogXLabel = new JLabel("CX");
        JLabel cogYLabel = new JLabel("CY");
        JLabel cogZLabel = new JLabel("CZ");
        this.cogXTextField = this.widgetFactory.createNumberField(null, UnitsValueConverterFactory.getLengthConverter());
        this.cogYTextField = this.widgetFactory.createNumberField(null, UnitsValueConverterFactory.getLengthConverter());
        this.cogZTextField = this.widgetFactory.createNumberField(null, UnitsValueConverterFactory.getLengthConverter());
        this.cogXTextField.setColumns(8);
        this.cogXTextField.setEditable(false);
        this.cogXTextField.setHorizontalAlignment(4);
        this.cogXTextField.setName(String.valueOf(PayloadEstimationFinaliseWizardPage.class.getSimpleName()) + ".cogXTextField");
        this.cogYTextField.setColumns(8);
        this.cogYTextField.setEditable(false);
        this.cogYTextField.setHorizontalAlignment(4);
        this.cogYTextField.setName(String.valueOf(PayloadEstimationFinaliseWizardPage.class.getSimpleName()) + ".cogYTextField");
        this.cogZTextField.setColumns(8);
        this.cogZTextField.setEditable(false);
        this.cogZTextField.setHorizontalAlignment(4);
        this.cogZTextField.setName(String.valueOf(PayloadEstimationFinaliseWizardPage.class.getSimpleName()) + ".cogZTextField");
        JPanel cogGridPanel = new JPanel(new GridBagLayout());
        cogGridPanel.setAlignmentX(0.5f);
        cogGridPanel.add((Component)cogXLabel, this.createGBCs(0, 0));
        cogGridPanel.add((Component)this.cogXTextField, this.createGBCs(1, 0));
        cogGridPanel.add((Component)cogYLabel, this.createGBCs(0, 1));
        cogGridPanel.add((Component)this.cogYTextField, this.createGBCs(1, 1));
        cogGridPanel.add((Component)cogZLabel, this.createGBCs(0, 2));
        cogGridPanel.add((Component)this.cogZTextField, this.createGBCs(1, 2));
        Box.Filler glue = new Box.Filler(new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.add(statePanel);
        this.add(Box.createVerticalStrut(15));
        this.add(descriptionPanel);
        this.add(Box.createVerticalStrut(25));
        this.add(payloadLabel);
        this.add(payloadComponent);
        this.add(Box.createVerticalStrut(25));
        this.add(cogLabel);
        this.add(cogGridPanel);
        this.add(glue);
    }

    private GridBagConstraints createGBCs(int gridX, int gridY) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridX;
        gbc.gridy = gridY;
        gbc.insets = new Insets(2, 2, 2, 2);
        return gbc;
    }

    public void setupWizardButtons() {
        this.fireButtonEvent(ButtonEvent.ButtonEventType.ENABLE_BUTTON, AbstractWizardPage.BUTTON_FINISH);
    }

    public void enter(Object object) {
        this.stateLabel.setIcon(this.payloadEstimationModel.getState() == PayloadEstimationModel.PayloadEstimationState.OK ? ImageResource.greenLed() : ImageResource.redLed());
        this.stateLabel.setText(this.payloadEstimationModel.getState().toString());
        this.payloadTextField.setValue((Object)this.payloadEstimationModel.getPayload());
        this.cogXTextField.setValue((Object)Length.from((double)this.payloadEstimationModel.getCog().getX(), (Length.Unit)Length.Unit.SI));
        this.cogYTextField.setValue((Object)Length.from((double)this.payloadEstimationModel.getCog().getY(), (Length.Unit)Length.Unit.SI));
        this.cogZTextField.setValue((Object)Length.from((double)this.payloadEstimationModel.getCog().getZ(), (Length.Unit)Length.Unit.SI));
    }

    public Object exit() {
        return null;
    }

    public JTextField getPayloadTextField() {
        return this.payloadTextField;
    }

    public JTextField getCogXTextField() {
        return this.cogXTextField;
    }

    public JTextField getCogYTextField() {
        return this.cogYTextField;
    }

    public JTextField getCogZTextField() {
        return this.cogZTextField;
    }
}

