/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.estimation;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.move.legacy.MoveRequester;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.payload.PayloadControllerRPC;
import com.ur.polyscope.payload.common.PayloadEstimationResult;
import com.ur.polyscope.payload.common.Wrench;
import com.ur.polyscope.payload.impl.installation.estimation.SelectPoseWizardPage;
import com.ur.polyscope.payload.impl.installation.estimation.entities.PayloadEstimationMeasurement;
import com.ur.polyscope.payload.impl.installation.estimation.entities.PayloadEstimationModel;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.wizard.AbstractWizardPage;
import com.ur.swing.wizard.ButtonEvent;
import java.awt.Component;
import java.awt.Font;
import javax.inject.Provider;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PayloadEstimationSelectPoseWizardPage
extends SelectPoseWizardPage {
    private PayloadEstimationModel payloadEstimationModel;
    private int pointIndex;
    private Provider<PayloadControllerRPC> providerControllerRPC;
    private JLabel stateLabel;

    public PayloadEstimationSelectPoseWizardPage(String title, ViewContext viewContext, VisualizerFactory visualizerFactory, Component robotCanvas3D, String description, CardPanel cardPanel, PayloadEstimationModel payloadEstimationModel, int pointIndex, Provider<PayloadControllerRPC> providerControllerRPC, PositionRequester positionRequester, MoveRequester moveRequester) {
        super(title, viewContext, visualizerFactory, robotCanvas3D, description, null, cardPanel, positionRequester, moveRequester);
        this.payloadEstimationModel = payloadEstimationModel;
        this.providerControllerRPC = providerControllerRPC;
        this.pointIndex = pointIndex;
        this.createSouthPanel();
    }

    private static Icon getIconForState(PayloadEstimationModel.PayloadEstimationState state) {
        switch (state) {
            case OK: {
                return ImageResource.greenLed();
            }
            case NOT_ENOUGH_POINTS: {
                return ImageResource.grayLed();
            }
            case POINTS_NOT_DIVERSE: {
                return ImageResource.redLed();
            }
        }
        return ImageResource.grayLed();
    }

    private void createSouthPanel() {
        JLabel infoTip = AbstractWizardPage.toHTMLFormattedJLabel((String)((TextResource)this.viewContext.getTextResource(TextResource.class)).payloadEstimationWizardTipToUseArrows());
        infoTip.setIcon(ImageResource.metalInfo());
        JPanel southPane = new JPanel();
        southPane.setLayout(new BoxLayout(southPane, 1));
        southPane.add(infoTip);
        southPane.add(Box.createVerticalStrut(30));
        this.add(southPane, "South");
    }

    @Override
    protected JComponent createTopComponent() {
        JPanel panel = new JPanel();
        this.stateLabel = new JLabel(PayloadEstimationModel.PayloadEstimationState.NOT_ENOUGH_POINTS.toString(), ImageResource.redLed(), 0);
        this.stateLabel.setFont(new Font(this.stateLabel.getFont().getName(), 1, this.stateLabel.getFont().getSize()));
        this.stateLabel.setName(String.valueOf(PayloadEstimationSelectPoseWizardPage.class.getSimpleName()) + ".stateLabel");
        panel.add(this.stateLabel);
        panel.setAlignmentX(0.5f);
        return panel;
    }

    private void calculatePayloadEstimationState() {
        int completedMeasurements = this.payloadEstimationModel.getCompletedMeasurementCount();
        if (completedMeasurements == this.payloadEstimationModel.getMeasurementList().size()) {
            PayloadControllerRPC controllerRPC = (PayloadControllerRPC)this.providerControllerRPC.get();
            Pose6d[] p = new Pose6d[completedMeasurements];
            Wrench[] w = new Wrench[completedMeasurements];
            int i = 0;
            while (i < completedMeasurements) {
                PayloadEstimationMeasurement m = this.payloadEstimationModel.getMeasurementList().get(i);
                p[i] = m.getPose();
                w[i] = m.getWrench();
                ++i;
            }
            PayloadEstimationResult result = controllerRPC.estimatePayload(p, w);
            if (result.isEstimated()) {
                this.payloadEstimationModel.setState(PayloadEstimationModel.PayloadEstimationState.OK);
                this.payloadEstimationModel.setPayload(result.getPayload());
                this.payloadEstimationModel.setCog(result.getCog());
            } else {
                this.payloadEstimationModel.setState(PayloadEstimationModel.PayloadEstimationState.POINTS_NOT_DIVERSE);
                this.payloadEstimationModel.setPayload(Weight.ZERO);
                this.payloadEstimationModel.setCog(null);
            }
        } else {
            this.payloadEstimationModel.setState(PayloadEstimationModel.PayloadEstimationState.NOT_ENOUGH_POINTS);
        }
    }

    @Override
    protected void setPoseAndJointPositionVector(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
        super.setPoseAndJointPositionVector(pose, jointPositionVector, tcpOffset);
        PayloadControllerRPC controllerRPC = (PayloadControllerRPC)this.providerControllerRPC.get();
        Wrench wrench = controllerRPC.getTCPForce(false);
        this.payloadEstimationModel.setMeasurement(this.pointIndex, new PayloadEstimationMeasurement(pose, jointPositionVector, wrench));
        this.calculatePayloadEstimationState();
    }

    private boolean stateOkOrNotFinalPosePage() {
        return this.payloadEstimationModel.getState() == PayloadEstimationModel.PayloadEstimationState.OK || this.pointIndex != this.payloadEstimationModel.getMeasurementList().size() - 1;
    }

    @Override
    public void setupWizardButtons() {
        if (this.isPoseSelected() && this.stateOkOrNotFinalPosePage()) {
            this.fireButtonEvent(ButtonEvent.ButtonEventType.ENABLE_BUTTON, AbstractWizardPage.BUTTON_NEXT);
        } else {
            this.fireButtonEvent(ButtonEvent.ButtonEventType.DISABLE_BUTTON, AbstractWizardPage.BUTTON_NEXT);
        }
        this.fireButtonEvent(ButtonEvent.ButtonEventType.ENABLE_BUTTON, AbstractWizardPage.BUTTON_PREV);
        this.fireButtonEvent(ButtonEvent.ButtonEventType.DISABLE_BUTTON, AbstractWizardPage.BUTTON_FINISH);
        this.fireButtonEvent(ButtonEvent.ButtonEventType.CHANGE_BUTTON_TEXT, "STEP");
    }

    @Override
    protected void updateComponents() {
        super.updateComponents();
        this.stateLabel.setIcon(PayloadEstimationSelectPoseWizardPage.getIconForState(this.payloadEstimationModel.getState()));
        this.stateLabel.setText(PayloadEstimationModel.getPayloadEstimationStateString(this.payloadEstimationModel.getState(), (TextResource)this.viewContext.getTextResource(TextResource.class)));
    }
}

