/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.estimation.entities;

import com.ur.polyscope.payload.impl.installation.estimation.entities.PayloadEstimationMeasurement;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.Weight;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;

public class PayloadEstimationModel {
    private static final int MEASUREMENT_COUNT = 4;
    private List<PayloadEstimationMeasurement> measurementList = new ArrayList<PayloadEstimationMeasurement>();
    private Weight payload;
    private Vector3d cog;
    private PayloadEstimationState state = PayloadEstimationState.NOT_ENOUGH_POINTS;

    public PayloadEstimationModel() {
        int i = 0;
        while (i < 4) {
            this.measurementList.add(null);
            ++i;
        }
    }

    public List<PayloadEstimationMeasurement> getMeasurementList() {
        return this.measurementList;
    }

    public void setMeasurementList(List<PayloadEstimationMeasurement> measurementList) {
        this.measurementList = measurementList;
    }

    public Weight getPayload() {
        return this.payload;
    }

    public void setPayload(Weight payload) {
        this.payload = payload;
    }

    public Vector3d getCog() {
        return this.cog;
    }

    public void setCog(Vector3d cog) {
        this.cog = cog;
    }

    public PayloadEstimationState getState() {
        return this.state;
    }

    public void setState(PayloadEstimationState state) {
        this.state = state;
    }

    public void setMeasurement(int index, PayloadEstimationMeasurement measurement) {
        this.measurementList.set(index, measurement);
    }

    public int getCompletedMeasurementCount() {
        int count = 0;
        for (PayloadEstimationMeasurement m : this.measurementList) {
            if (m == null) continue;
            ++count;
        }
        return count;
    }

    public static String getPayloadEstimationStateString(PayloadEstimationState state, TextResource tr) {
        switch (state) {
            case OK: {
                return tr.OK();
            }
            case POINTS_NOT_DIVERSE: {
                return tr.PointsNotSufficientlyDiverse();
            }
            case NOT_ENOUGH_POINTS: {
                return tr.MorePointsNeeded();
            }
        }
        return "";
    }

    public void clear() {
        this.state = PayloadEstimationState.NOT_ENOUGH_POINTS;
        this.payload = Weight.ZERO;
        this.cog = null;
        int i = 0;
        while (i < this.measurementList.size()) {
            this.measurementList.set(i, null);
            ++i;
        }
    }

    public static enum PayloadEstimationState {
        NOT_ENOUGH_POINTS,
        POINTS_NOT_DIVERSE,
        OK;

    }
}

