/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.internal;

import com.ur.lang.naming.NamingService;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.swing.validation.ValidationStrategy;
import javax.inject.Inject;
import javax.swing.JComboBox;

public class PayloadNameValidator {
    private final NamingService namingService;
    private final TextResource textResource;

    @Inject
    public PayloadNameValidator(NamingService namingService, TextResource textResource) {
        this.namingService = namingService;
        this.textResource = textResource;
    }

    public ValidationStrategy getPayloadNameValidationStrategy(final JComboBox jComboBox) {
        return new ValidationStrategy(){

            public boolean isValid(String name) {
                String oldName = "";
                Object selectedItem = jComboBox.getModel().getSelectedItem();
                if (selectedItem instanceof InstallationPayloadComponent) {
                    oldName = ((InstallationPayloadComponent)selectedItem).getName();
                }
                return PayloadNameValidator.this.namingService.isNameValid(InstallationPayloadComponent.class, name) && !PayloadNameValidator.this.namingService.isNameUsed(InstallationPayloadComponent.class, name) || name.equals(oldName);
            }

            public String getErrorMessage(String name) {
                if (name.length() == 0) {
                    return "";
                }
                int maximumLength = PayloadNameValidator.this.namingService.maxNameLength(InstallationPayloadComponent.class);
                if (name.length() > maximumLength) {
                    return PayloadNameValidator.this.textResource.maximumTextLength(maximumLength);
                }
                if (!PayloadNameValidator.this.namingService.isNameValid(InstallationPayloadComponent.class, name) || PayloadNameValidator.this.namingService.isReservedName(name)) {
                    return PayloadNameValidator.this.textResource.illegalName();
                }
                if (PayloadNameValidator.this.namingService.isNameUsed(InstallationPayloadComponent.class, name)) {
                    return PayloadNameValidator.this.textResource.nameIsAlreadyUsed();
                }
                return PayloadNameValidator.this.textResource.illegalName();
            }
        };
    }
}

