/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.internal;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.impl.common.internal.InstallationPayloadRenderer;
import com.ur.polyscope.payload.impl.robotstate.model.PayloadAttributesModel;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuListener;

public class PayloadsListCreator {
    private final TextResource textResource;
    private final Recipe<PayloadAttributesModel> payloadRecipe;
    private final PayloadService payloadService;

    @Inject
    public PayloadsListCreator(PayloadService payloadService, TextResource textResource, @Source(value=PayloadAttributesModel.class) Recipe<PayloadAttributesModel> payloadRecipe) {
        this.payloadService = payloadService;
        this.textResource = textResource;
        this.payloadRecipe = payloadRecipe;
    }

    public JComboBox getPayloadsList() {
        JComboBox payloadListComboBox = new JComboBox();
        payloadListComboBox.setName(com.ur.polyscope.application.driver.payload.names.PayloadsListCreator.AVAILABLE_PAYLOADS);
        payloadListComboBox.setPreferredSize(new Dimension(180, 32));
        this.payloadRecipe.executeOnUIThread().subscribe(payloadModel -> payloadListComboBox.setSelectedItem(this.payloadService.getActivePayload()));
        InstallationPayloadRenderer installationPayloadRenderer = new InstallationPayloadRenderer(this.payloadService, this.textResource);
        payloadListComboBox.setRenderer(new ContributedComboBoxRenderer((RenderingStrategy)installationPayloadRenderer));
        payloadListComboBox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer((RenderingStrategy)installationPayloadRenderer, 500));
        return payloadListComboBox;
    }
}

