/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.visualization;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.installation.visualization.PayloadVisualizerElement;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.swing.card.EnterExitCard;
import com.ur.swing.g5.CardBorder;
import com.ur.util.event.Subscription;
import java.awt.BorderLayout;
import java.util.Collections;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Payload3DCanvas
extends JPanel
implements EnterExitCard {
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final Recipe<Arm> armRecipe;
    private RobotCanvas3D robotView3DPanel;
    private Subscription armSubscribtion;
    private final PayloadVisualizerElement payloadVisualizerElement;
    private UpdateZoomInCanvas updateZoomInCanvas;

    @Inject
    public Payload3DCanvas(RobotCanvas3DFactory robotCanvas3DFactory, @Source(value=Arm.class) Recipe<Arm> armRecipe, TextResource textResource, FeaturesLookup featuresLookup) {
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.armRecipe = armRecipe;
        this.payloadVisualizerElement = new PayloadVisualizerElement(armRecipe);
        this.setLayout(new BorderLayout());
        this.setBorder((Border)new CardBorder(textResource.payloadVisualization()));
        this.initRobotView3DPanel();
        ViewBehaviorWrapper wrapper = new ViewBehaviorWrapper(featuresLookup);
        ZoomRenderer zr = new ZoomRenderer(this.robotView3DPanel.getComponent(), (ViewBehaviorHolder)wrapper);
        this.robotView3DPanel.addJ3DComponent((J3DComponent)zr);
        this.updateZoomInCanvas = new UpdateZoomInCanvas((ViewBehaviorHolder)wrapper);
    }

    private void initRobotView3DPanel() {
        this.robotView3DPanel = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotView3DPanel.setDebugName("G5 PAYLOAD 3D Canvas");
        this.robotView3DPanel.setRobotAttached(true);
        this.robotView3DPanel.setVisible(false);
        this.robotView3DPanel.showDynamicElements(Collections.singletonList(this.payloadVisualizerElement));
        new URCanvas3DFingerDragViewShifter(this.robotView3DPanel);
        this.add(this.robotView3DPanel.getComponent(), "Center");
    }

    public void enter(Object o) {
        this.robotView3DPanel.setVisible(true);
        this.robotView3DPanel.enter();
        this.robotView3DPanel.alwaysRun((Runnable)this.updateZoomInCanvas);
        this.armSubscribtion = this.armRecipe.executeOnUIThread().subscribe((Consumer)new ArmConsumer());
    }

    public Object exit() {
        this.armSubscribtion.dispose();
        this.robotView3DPanel.setVisible(false);
        this.robotView3DPanel.exit();
        return null;
    }

    void setSelectedPayload(PayloadComponent payload) {
        this.payloadVisualizerElement.setBoxDimensions(payload);
    }

    private class ArmConsumer
    implements Consumer<Arm> {
        private ArmConsumer() {
        }

        public void accept(Arm arm) {
            Payload3DCanvas.this.robotView3DPanel.setJointAngleVector(arm.getActualJointsPosition());
        }
    }
}

