/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.installation.visualization;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import com.ur.lang.react.Recipe;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.impl.common.domain.InertiaDecomposition;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.utils.MaterialDB;
import com.ur.polyscope.visualizer.utils.Pose6dTransformUtils;
import javax.inject.Provider;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PayloadVisualizerElement
implements VisualizerElement {
    private BranchGroup branchGroup;
    private BranchGroup subBranchGroup;
    private BranchGroup sphereBranchGroup;
    private BranchGroup boxSubBranchGroup;
    private TransformGroup transformGroup;
    private Node box;
    private final Provider<Arm> armRecipeProvider;
    private Vector3d rotation = new Vector3d();
    private Vector3d position = new Vector3d();

    public PayloadVisualizerElement(Recipe<Arm> armRecipe) {
        this.armRecipeProvider = armRecipe.lastProvider();
    }

    public VisualizerElementType getElementType() {
        return VisualizerElementType.PAYLOAD_COG;
    }

    public Node getElementNode() {
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(13);
        this.branchGroup.setCapability(14);
        this.subBranchGroup = new BranchGroup();
        this.createVisualization();
        return this.branchGroup;
    }

    public Node getVisualizerNode() {
        this.sphereBranchGroup = new BranchGroup();
        this.sphereBranchGroup.setCapability(13);
        this.sphereBranchGroup.setCapability(14);
        this.boxSubBranchGroup = new BranchGroup();
        this.boxSubBranchGroup.setCapability(13);
        this.boxSubBranchGroup.setCapability(17);
        this.box = new Box(0.0f, 0.0f, 0.0f, this.createBoxAppearance());
        Sphere sphere = new Sphere(0.01f, this.createBoxAppearance());
        this.boxSubBranchGroup.addChild(this.box);
        this.sphereBranchGroup.addChild((Node)this.boxSubBranchGroup);
        this.sphereBranchGroup.addChild((Node)sphere);
        return this.sphereBranchGroup;
    }

    private void createVisualization() {
        this.transformGroup = new TransformGroup();
        this.transformGroup.addChild(this.getVisualizerNode());
        this.transformGroup.setCapability(18);
        this.transformGroup.setCapability(13);
        this.subBranchGroup.addChild((Node)this.transformGroup);
        this.branchGroup.addChild((Node)this.subBranchGroup);
    }

    public void update() {
        Pose6d cogPose = this.getCoGPosition((Arm)this.armRecipeProvider.get());
        this.transformGroup.setTransform(Pose6dTransformUtils.getTransform3D((Pose6d)cogPose));
    }

    private Pose6d getCoGPosition(Arm arm) {
        Pose6d toolPose = arm.getTool().getCartesianInfo().getTool();
        Pose6d activeTcpOffset = arm.getTool().getCartesianInfo().getTcpOffset();
        Pose6d selectedCoGOffset = new Pose6d((Tuple3d)this.position, (Tuple3d)this.rotation);
        return Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)toolPose, (Pose6d)activeTcpOffset, (Pose6d)selectedCoGOffset);
    }

    public void setBoxDimensions(PayloadComponent payload) {
        if (payload == null) {
            this.rotation = new Vector3d();
            this.position = new Vector3d();
            this.box = new Box(0.0f, 0.0f, 0.0f, this.createBoxAppearance());
        } else {
            InertiaDecomposition inertiaDecomposition = new InertiaDecomposition(payload);
            this.rotation = inertiaDecomposition.getRotation();
            this.position = payload.getCenterOfGravity();
            this.box = new Box((float)Math.abs(inertiaDecomposition.getX() / 2.0), (float)Math.abs(inertiaDecomposition.getY() / 2.0), (float)Math.abs(inertiaDecomposition.getZ() / 2.0), this.createBoxAppearance());
        }
        if (this.boxSubBranchGroup != null && this.sphereBranchGroup != null) {
            this.boxSubBranchGroup.detach();
            this.boxSubBranchGroup = new BranchGroup();
            this.boxSubBranchGroup.setCapability(13);
            this.boxSubBranchGroup.setCapability(17);
            this.boxSubBranchGroup.addChild(this.box);
            this.sphereBranchGroup.addChild((Node)this.boxSubBranchGroup);
        }
    }

    private Appearance createBoxAppearance() {
        Appearance boxAppearance = new Appearance();
        boxAppearance.setMaterial(MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.BLACK_RUBBER));
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparency(0.5f);
        transparencyAttributes.setTransparencyMode(0);
        boxAppearance.setTransparencyAttributes(transparencyAttributes);
        return boxAppearance;
    }
}

