/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.program.data;

import com.ur.injection.Builder;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.XmlDataModel;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.impl.program.domain.SetPayloadNode;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.persist.ProgramComponentConversionStrategy;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.Weight;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class SetPayloadConversionStrategy
extends ConversionStrategyTemplate<SetPayloadNode>
implements ProgramComponentConversionStrategy<SetPayloadNode> {
    private static final String WORKPIECE_NAME = "workpieceName";
    private static final String CUSTOM_PAYLOAD_WEIGHT_SI = "customPayloadWeight";
    private static final String CUSTOM_PAYLOAD_COG_SI = "customPayloadCenterOfGravity";
    private static final String PAYLOAD_TRANSITION_TIME_SI = "payloadTransitionTime";
    private static final String CUSTOM_PAYLOAD_INERTIA_SI = "customPayloadInertia";
    private static final String CUSTOM_PAYLOAD_INERTIA_ENABLED_SI = "customPayloadInertiaEnabled";
    private static final String SET_PAYLOAD_NODE = "SetPayload";
    private final Builder builder;
    private final PayloadService payloadService;

    @Inject
    public SetPayloadConversionStrategy(Builder builder, PayloadService payloadService) {
        super(SetPayloadNode.class);
        this.builder = builder;
        this.payloadService = payloadService;
    }

    public void marshal(SetPayloadNode setPayloadNode, PersistWriter persistWriter) {
        XmlDataModel dataModel = new XmlDataModel(persistWriter);
        if (this.isCustomPayloadComponent(setPayloadNode)) {
            this.writeSetPayloadNode(setPayloadNode, dataModel);
        } else {
            this.writeInstallationPayloadReferenceComponent(setPayloadNode, dataModel);
        }
    }

    private boolean isCustomPayloadComponent(SetPayloadNode setPayloadNode) {
        return Objects.isNull(setPayloadNode.getPayloadReferenceComponent());
    }

    private void writeSetPayloadNode(SetPayloadNode setPayloadNode, XmlDataModel dataModel) {
        PayloadComponent customPayload = (PayloadComponent)setPayloadNode.getPayloadDomain();
        dataModel.set(CUSTOM_PAYLOAD_WEIGHT_SI, customPayload.getMass().getIn(Weight.Unit.SI));
        dataModel.set(CUSTOM_PAYLOAD_COG_SI, this.vector3dToArray(customPayload.getCenterOfGravity()));
        dataModel.set(CUSTOM_PAYLOAD_INERTIA_SI, this.matrix3dToArray(customPayload.getInertiaMatrix()));
        dataModel.set(CUSTOM_PAYLOAD_INERTIA_ENABLED_SI, customPayload.isCustomInertiaEnabled());
        dataModel.set(PAYLOAD_TRANSITION_TIME_SI, setPayloadNode.getTransitionTime().getIn(Time.Unit.SECONDS));
    }

    private void writeInstallationPayloadReferenceComponent(SetPayloadNode setPayloadNode, XmlDataModel dataModel) {
        PayloadReferenceComponent payloadReferenceComponent = setPayloadNode.getPayloadReferenceComponent();
        dataModel.set(WORKPIECE_NAME, payloadReferenceComponent.getKey());
        dataModel.set(PAYLOAD_TRANSITION_TIME_SI, setPayloadNode.getTransitionTime().getIn(Time.Unit.SECONDS));
    }

    public SetPayloadNode unmarshal(PersistReader persistReader) {
        SetPayloadNode payloadNode = (SetPayloadNode)((Object)this.builder.get(SetPayloadNode.class));
        XmlDataModel dataModel = new XmlDataModel(persistReader);
        if (this.isInstallationPayloadReferenceComponent(dataModel)) {
            PayloadReferenceComponent payloadReferenceComponent = this.readPayloadReferenceComponent(dataModel);
            payloadNode.setPayloadReferenceComponent(payloadReferenceComponent);
        } else {
            payloadNode.setPayloadDomain((DomainComponent)this.readPayloadComponent(dataModel));
        }
        payloadNode.setTransitionTime(SetPayloadConversionStrategy.getTransitionTimeFromDataModel(dataModel));
        return payloadNode;
    }

    private boolean isInstallationPayloadReferenceComponent(XmlDataModel dataModel) {
        return dataModel.isSet(WORKPIECE_NAME);
    }

    private PayloadReferenceComponent readPayloadReferenceComponent(XmlDataModel dataModel) {
        String referenceName = dataModel.get(WORKPIECE_NAME, null);
        return new PayloadReferenceComponent(referenceName, this.payloadService);
    }

    private static Time getTransitionTimeFromDataModel(XmlDataModel dataModel) {
        return Time.from((double)dataModel.get(PAYLOAD_TRANSITION_TIME_SI, 0.0), (Time.Unit)Time.Unit.SECONDS);
    }

    private PayloadComponent readPayloadComponent(XmlDataModel dataModel) {
        return new PayloadComponent(Weight.from((double)dataModel.get(CUSTOM_PAYLOAD_WEIGHT_SI, 0.0), (Weight.Unit)Weight.Unit.SI), new Vector3d(dataModel.get(CUSTOM_PAYLOAD_COG_SI, new double[3])), new Matrix3d(dataModel.get(CUSTOM_PAYLOAD_INERTIA_SI, new double[9])));
    }

    public Map<String, Class<? extends SetPayloadNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap(SET_PAYLOAD_NODE, SetPayloadNode.class);
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        boolean isSetPayloadNode = reader.getNodeName().equals(SET_PAYLOAD_NODE);
        boolean isClassSetPayloadNode = SetPayloadConversionStrategy.isClassSetPayloadNode(reader);
        return isSetPayloadNode || isClassSetPayloadNode;
    }

    private static boolean isClassSetPayloadNode(PersistReader reader) {
        String classAttribute = reader.getStringAttribute("class");
        if (classAttribute != null) {
            return classAttribute.equals(SET_PAYLOAD_NODE);
        }
        return false;
    }

    private double[] vector3dToArray(Vector3d v) {
        double[] vArr = new double[3];
        v.get(vArr);
        return vArr;
    }

    private double[] matrix3dToArray(Matrix3d m) {
        double[] r0 = new double[3];
        double[] r1 = new double[3];
        double[] r2 = new double[3];
        m.getRow(0, r0);
        m.getRow(1, r1);
        m.getRow(2, r2);
        double[] mArr = new double[9];
        System.arraycopy(r0, 0, mArr, 0, 3);
        System.arraycopy(r1, 0, mArr, 3, 3);
        System.arraycopy(r2, 0, mArr, 6, 3);
        return mArr;
    }
}

